/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import java.io.File;
import java.io.IOException;

final class FindReferencesRecipeExecutor
implements RecipeExecutor {
    private final RenderingContext myContext;

    public FindReferencesRecipeExecutor(RenderingContext context) {
        this.myContext = context;
    }

    @Override
    public void copy(File from, File to) {
        if (from.isDirectory()) {
            throw new RuntimeException("Directories not supported for Find References");
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void instantiate(File from, File to) {
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void merge(File from, File to) {
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void mkDir(File at) {
    }

    @Override
    public void addFilesToOpen(File file) {
        this.myContext.getFilesToOpen().add(this.resolveTargetFile(file));
    }

    @Override
    public void addDependency(String mavenUrl) {
        this.myContext.getDependencies().add(mavenUrl);
    }

    @Override
    public void updateAndSyncGradle() {
    }

    @Override
    public void pushFolder(String folder) {
    }

    @Override
    public void popFolder() {
    }

    public void addSourceFile(File file) {
        this.myContext.getSourceFiles().add(this.resolveSourceFile(file));
    }

    public void addTargetFile(File file) {
        this.myContext.getTargetFiles().add(this.resolveTargetFile(file));
    }

    private File resolveSourceFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        try {
            return this.myContext.getLoader().getSourceFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File resolveTargetFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myContext.getOutputRoot(), file.getPath());
    }
}

