/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.GradleFileMerger;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class DefaultRecipeExecutor
implements RecipeExecutor {
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private final FindReferencesRecipeExecutor myReferences;
    private final RenderingContext myContext;
    private final RecipeIO myIO;
    private final ReadonlyStatusHandler myReadonlyStatusHandler;
    private boolean myNeedsGradleSync;

    public DefaultRecipeExecutor(RenderingContext context, boolean dryRun) {
        this.myReferences = new FindReferencesRecipeExecutor(context);
        this.myContext = context;
        this.myIO = dryRun ? new DryRunRecipeIO() : new RecipeIO();
        this.myReadonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)context.getProject());
    }

    @Override
    public void addDependency(String mavenUrl) {
        this.myReferences.addDependency(mavenUrl);
        List dependencyList = (List)this.getParamMap().get("dependencyList");
        dependencyList.add(mavenUrl);
    }

    @Override
    public void addFilesToOpen(File file) {
        this.myReferences.addFilesToOpen(file);
    }

    private void addWarning(String warning) {
        this.myContext.getWarnings().add(warning);
    }

    private Map<String, Object> getParamMap() {
        return this.myContext.getParamMap();
    }

    Configuration getFreemarker() {
        return this.myContext.getFreemarkerConfiguration();
    }

    @Override
    public void copy(File from, File to) {
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void instantiate(File from, File to) throws FreemarkerUtils.TemplateProcessingException {
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                File sourceFile = this.myContext.getLoader().getSourceFile(from);
                File targetFile = this.getTargetFile(to);
                String content = FreemarkerUtils.processFreemarkerTemplate(this.myContext, sourceFile, null);
                if (targetFile.exists()) {
                    if (!this.compareTextFile(targetFile, content)) {
                        this.addFileAlreadyExistWarning(targetFile);
                    }
                } else {
                    this.myIO.writeFile(this, content, targetFile);
                    this.myReferences.addSourceFile(sourceFile);
                    this.myReferences.addTargetFile(targetFile);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(File from, File to) throws FreemarkerUtils.TemplateProcessingException {
        try {
            String contents;
            String sourceText;
            String targetText = null;
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(targetFile, ".xml") && !TemplateUtils.hasExtension(targetFile, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + targetFile);
            }
            if (targetFile.exists()) {
                VirtualFile toFile;
                ReadonlyStatusHandler.OperationStatus status;
                if (this.myContext.getProject().isInitialized() && (status = this.myReadonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{toFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)})).hasReadonlyFiles()) {
                    throw new FreemarkerUtils.TemplateUserVisibleException(String.format("Attempt to update file that is readonly: %1$s", targetFile.getAbsolutePath()));
                }
                targetText = this.readTextFile(targetFile);
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, targetFile);
                } else {
                    this.copyTemplateResource(from, targetFile);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myContext, from, null);
            } else {
                sourceText = TemplateUtils.readTextFromDisk(sourceFile);
                if (sourceText == null) {
                    return;
                }
            }
            if (targetFile.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsGradleSync = true;
            } else if (targetFile.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
                contents = GradleFileMerger.mergeGradleFiles(sourceText, targetText, this.myContext.getProject(), compileSdkVersion);
                this.myNeedsGradleSync = true;
            } else if (TemplateUtils.hasExtension(targetFile, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myContext, sourceText, targetText, targetFile);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + targetFile);
            }
            this.myIO.writeFile(this, contents, targetFile);
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkDir(File at) {
        try {
            this.myIO.mkDir(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAndSyncGradle() {
        if (!this.myContext.getDependencies().isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Project project = this.myContext.getProject();
        if (this.myNeedsGradleSync && this.myContext.performGradleSync() && !project.isDefault() && Projects.isBuildWithGradle(project)) {
            this.myIO.requestGradleSync(project);
        }
    }

    @Override
    public void pushFolder(String folder) {
        try {
            this.myContext.getLoader().pushTemplateFolder(folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void popFolder() {
        this.myContext.getLoader().popTemplateFolder();
    }

    private File getTargetFile(File file) throws IOException {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myContext.getOutputRoot(), file.getPath());
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(this.myContext.getModuleRoot());
        String destinationContents = null;
        if (gradleBuildFile.exists()) {
            destinationContents = this.readTextFile(gradleBuildFile);
        }
        if (destinationContents == null) {
            destinationContents = "";
        }
        String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
        String result = GradleFileMerger.mergeGradleFiles(this.formatDependencies(), destinationContents, this.myContext.getProject(), compileSdkVersion);
        this.myIO.writeFile(this, result, gradleBuildFile);
        this.myNeedsGradleSync = true;
    }

    private String formatDependencies() {
        StringBuilder dependencies = new StringBuilder();
        dependencies.append("dependencies {\n");
        for (String dependency : this.myContext.getDependencies()) {
            dependencies.append("  compile '").append(dependency).append("'\n");
        }
        dependencies.append("}\n");
        return dependencies.toString();
    }

    private void copyDirectory(final VirtualFile src, final File dest) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(VirtualFile file) {
                try {
                    return DefaultRecipeExecutor.this.copyFile(file, src, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private void copyTemplateResource(File from, File to) throws IOException {
        File destPath;
        File source = this.myContext.getLoader().getSourceFile(from);
        File target = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)source, (boolean)true);
        assert (sourceFile != null) : source;
        sourceFile.refresh(false, false);
        File file = destPath = source.isDirectory() ? target : target.getParentFile();
        if (source.isDirectory()) {
            this.copyDirectory(sourceFile, destPath);
        } else if (target.exists()) {
            if (!this.compareFile(sourceFile, target)) {
                this.addFileAlreadyExistWarning(target);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.myIO.writeFile(this, document.getText(), target);
            } else {
                this.myIO.copyFile(this, sourceFile, destPath, target.getName());
            }
            this.myReferences.addSourceFile(source);
            this.myReferences.addTargetFile(target);
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            throw new RuntimeException(String.format("%1$s is not a child of %2$s", file.getPath(), src));
        }
        if (file.isDirectory()) {
            this.myIO.mkDir(new File(destinationFile, relativePath));
        } else {
            File target = new File(destinationFile, relativePath);
            if (target.exists()) {
                if (!this.compareFile(file, target)) {
                    this.addFileAlreadyExistWarning(target);
                }
            } else {
                this.myIO.copyFile(this, file, target);
                this.myReferences.addSourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                this.myReferences.addTargetFile(target);
            }
        }
        return true;
    }

    private String readTextFile(File file) {
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(file);
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String readTextFile(VirtualFile file) {
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    public boolean compareFile(VirtualFile sourceVFile, File targetFile) throws IOException {
        VirtualFile targetVFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true);
        if (targetVFile == null) {
            return false;
        }
        if (sourceVFile.getFileType().isBinary()) {
            byte[] source = sourceVFile.contentsToByteArray();
            byte[] target = targetVFile.contentsToByteArray();
            return Arrays.equals(source, target);
        }
        String source = this.readTextFile(sourceVFile);
        String target = this.readTextFile(targetVFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)source, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public boolean compareTextFile(File targetFile, String content) {
        String target = this.readTextFile(targetFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)content, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private void addFileAlreadyExistWarning(File targetFile) {
        this.addWarning(String.format("The following file could not be created since it already exists: %1$s", targetFile.getName()));
    }

    private static class DryRunRecipeIO
    extends RecipeIO {
        private DryRunRecipeIO() {
        }

        @Override
        public void writeFile(Object requestor, String contents, File to) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(to.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, VirtualFile file, File toFile) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(toFile.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, VirtualFile file, File toFileDir, String newName) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(toFileDir);
        }

        @Override
        public void mkDir(File directory) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(directory);
        }

        @Override
        public void requestGradleSync(Project project) {
        }
    }

    private static class RecipeIO {
        private RecipeIO() {
        }

        public void writeFile(Object requestor, String contents, File to) throws IOException {
            TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            TemplateUtils.writeTextFile(this, contents, to);
        }

        public void copyFile(Object requestor, VirtualFile file, File toFile) throws IOException {
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFile.getParentFile());
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)toDir);
        }

        public void copyFile(Object requestor, VirtualFile file, File toFileDir, String newName) throws IOException {
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFileDir);
            VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)toDir, (String)newName);
        }

        public void mkDir(File directory) throws IOException {
            TemplateUtils.checkedCreateDirectoryIfMissing(directory);
        }

        public void requestGradleSync(Project project) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

