/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryUrlManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.RepositoryUrlManager");
    public static final String TAG_VERSION = "version";
    public static final String SUPPORT_ID_V4 = "support-v4";
    public static final String SUPPORT_ID_V13 = "support-v13";
    public static final String APP_COMPAT_ID_V7 = "appcompat-v7";
    public static final String DESIGN = "design";
    public static final String GRID_LAYOUT_ID_V7 = "gridlayout-v7";
    public static final String MEDIA_ROUTER_ID_V7 = "mediarouter-v7";
    public static final String PLAY_SERVICES_ID = "play-services";
    public static final String PLAY_SERVICES_ADS_ID = "play-services-ads";
    public static final String PLAY_SERVICES_WEARABLE_ID = "play-services-wearable";
    public static final String PLAY_SERVICES_MAPS_ID = "play-services-maps";
    public static final String SUPPORT_WEARABLE_ID = "wearable";
    public static final String CARDVIEW_ID_V7 = "cardview-v7";
    public static final String LEANBACK_ID_V17 = "leanback-v17";
    public static final String PALETTE_ID_V7 = "palette-v7";
    public static final String RECYCLER_VIEW_ID_V7 = "recyclerview-v7";
    public static final String SUPPORT_ANNOTATIONS = "support-annotations";
    public static final String COMPATIBILITY_ID = "compatibility";
    public static final String REVISION_ANY = "0.0.+";
    private static final String SUPPORT_BASE_COORDINATE = "com.android.support:%s:%s";
    private static final String GOOGLE_BASE_COORDINATE = "com.google.android.gms:%s:%s";
    private static final String GOOGLE_SUPPORT_BASE_COORDINATE = "com.google.android.support:%s:%s";
    private static final String SUPPORT_REPOSITORY_BASE_PATH = "%s/extras/android/m2repository/com/android/support/%s/";
    private static final String GOOGLE_REPOSITORY_BASE_PATH = "%s/extras/google/m2repository/com/google/android/gms/%s/";
    private static final String GOOGLE_SUPPORT_REPOSITORY_BASE_PATH = "%s/extras/google/m2repository/com/google/android/support/%s/";
    private static final String MAVEN_REVISION_PATH = "%2$s/%1$s-%2$s";
    public static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";
    public static final String HELP_COMMENT = "// You must install or update the %1$s Repository through the SDK manager to use this dependency.";
    private static final RangeMap<Integer, String> SUPPORT_LIBRARY_EXTENSIONS = ImmutableRangeMap.builder().put(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(19)), (Object)".jar").put(Range.atLeast((Comparable)Integer.valueOf(20)), (Object)".aar").build();
    public static final Map<String, RepositoryLibrary> EXTRAS_REPOSITORY = new ImmutableMap.Builder().put((Object)"support-annotations", (Object)new RepositoryLibrary("support-annotations", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".jar")).put((Object)"support-v4", (Object)new RepositoryLibrary("support-v4", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", SUPPORT_LIBRARY_EXTENSIONS)).put((Object)"support-v13", (Object)new RepositoryLibrary("support-v13", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", SUPPORT_LIBRARY_EXTENSIONS)).put((Object)"appcompat-v7", (Object)new RepositoryLibrary("appcompat-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"design", (Object)new RepositoryLibrary("design", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"gridlayout-v7", (Object)new RepositoryLibrary("gridlayout-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"mediarouter-v7", (Object)new RepositoryLibrary("mediarouter-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"play-services", (Object)new RepositoryLibrary("play-services", "%s/extras/google/m2repository/com/google/android/gms/%s/", "com.google.android.gms:%s:%s", ".aar")).put((Object)"play-services-ads", (Object)new RepositoryLibrary("play-services-ads", "%s/extras/google/m2repository/com/google/android/gms/%s/", "com.google.android.gms:%s:%s", ".aar")).put((Object)"play-services-wearable", (Object)new RepositoryLibrary("play-services-wearable", "%s/extras/google/m2repository/com/google/android/gms/%s/", "com.google.android.gms:%s:%s", ".aar")).put((Object)"play-services-maps", (Object)new RepositoryLibrary("play-services-maps", "%s/extras/google/m2repository/com/google/android/gms/%s/", "com.google.android.gms:%s:%s", ".aar")).put((Object)"cardview-v7", (Object)new RepositoryLibrary("cardview-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"palette-v7", (Object)new RepositoryLibrary("palette-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"recyclerview-v7", (Object)new RepositoryLibrary("recyclerview-v7", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"leanback-v17", (Object)new RepositoryLibrary("leanback-v17", "%s/extras/android/m2repository/com/android/support/%s/", "com.android.support:%s:%s", ".aar")).put((Object)"wearable", (Object)new RepositoryLibrary("wearable", "%s/extras/google/m2repository/com/google/android/support/%s/", "com.google.android.support:%s:%s", ".aar")).build();
    private static final Predicate<GradleCoordinate> IS_NOT_PREVIEW = new Predicate<GradleCoordinate>(){

        public boolean apply(GradleCoordinate input) {
            return !input.isPreview();
        }
    };
    private static final Ordering<GradleCoordinate> GRADLE_COORDINATE_ORDERING = new Ordering<GradleCoordinate>(){

        public int compare(GradleCoordinate left, GradleCoordinate right) {
            return GradleCoordinate.COMPARE_PLUS_LOWER.compare(left, right);
        }
    };

    public static RepositoryUrlManager get() {
        return new RepositoryUrlManager();
    }

    RepositoryUrlManager() {
    }

    public String getLibraryCoordinate(String libraryId) {
        return this.getLibraryCoordinate(libraryId, null, true);
    }

    public String getLibraryCoordinate(String groupId, String artifactId, String filterPrefix, boolean includePreviews) {
        SdkMavenRepository repository = SdkMavenRepository.getByGroupId((String)groupId);
        if (repository == null) {
            return null;
        }
        AndroidSdkData sdk = this.tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        File sdkLocation = sdk.getLocation();
        File repo = repository.getRepositoryLocation(sdkLocation, false);
        if (repo == null) {
            return null;
        }
        GradleCoordinate max = repository.getHighestInstalledVersion(sdk.getLocation(), groupId, artifactId, filterPrefix, includePreviews);
        if (max == null) {
            return null;
        }
        return max.getFullRevision();
    }

    @Deprecated
    public String getLibraryCoordinate(String libraryId, String filterPrefix, boolean includePreviews) {
        if (!EXTRAS_REPOSITORY.containsKey(libraryId)) {
            return null;
        }
        AndroidSdkData sdk = this.tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        String sdkLocation = sdk.getLocation().getPath();
        RepositoryLibrary library = EXTRAS_REPOSITORY.get(libraryId);
        File supportMetadataFile = new File(String.format(library.basePath, sdkLocation, library.id), MAVEN_METADATA_FILE_NAME);
        if (!this.fileExists(supportMetadataFile)) {
            return String.format(library.baseCoordinate, library.id, REVISION_ANY);
        }
        String version = this.getLatestVersionFromMavenMetadata(supportMetadataFile, filterPrefix, includePreviews);
        return version != null ? String.format(library.baseCoordinate, library.id, version) : null;
    }

    public File getArchiveForCoordinate(GradleCoordinate gradleCoordinate) {
        AndroidSdkData sdk = this.tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        String sdkLocation = sdk.getLocation().getPath();
        String artifactId = gradleCoordinate.getArtifactId();
        String revision = gradleCoordinate.getFullRevision();
        RepositoryLibrary library = EXTRAS_REPOSITORY.get(artifactId);
        File path = new File(String.format(library.basePath, sdkLocation, library.id));
        String revisionPath = String.format(MAVEN_REVISION_PATH, library.id, revision) + library.getArchiveExtension(gradleCoordinate.getMajorVersion());
        return new File(path, revisionPath);
    }

    public static boolean supports(String libraryId) {
        return EXTRAS_REPOSITORY.containsKey(libraryId);
    }

    private String getLatestVersionFromMavenMetadata(final File metadataFile, final String filterPrefix, final boolean includePreviews) {
        String xml = this.readTextFile(metadataFile);
        final LinkedList versions = Lists.newLinkedList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new ByteArrayInputStream(xml.getBytes()), new DefaultHandler(){
                boolean inVersionTag = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(RepositoryUrlManager.TAG_VERSION)) {
                        this.inVersionTag = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inVersionTag) {
                        this.inVersionTag = false;
                        String revision = new String(ch, start, length);
                        if (!(!includePreviews && "5.2.08".equals(revision) && metadataFile.getPath().contains(RepositoryUrlManager.PLAY_SERVICES_ID) || filterPrefix != null && !revision.startsWith(filterPrefix))) {
                            versions.add(GradleCoordinate.parseVersionOnly((String)revision));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (versions.isEmpty()) {
            return REVISION_ANY;
        }
        if (includePreviews) {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max((Iterable)versions)).getFullRevision();
        }
        try {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max(Iterables.filter((Iterable)versions, IS_NOT_PREVIEW))).getFullRevision();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public GradleCoordinate resolveDynamicCoordinate(GradleCoordinate coordinate, Project project) {
        List revisions;
        String version = this.resolveDynamicCoordinateVersion(coordinate, project);
        if (version != null && coordinate.getGroupId() != null && coordinate.getArtifactId() != null && !(revisions = GradleCoordinate.parseRevisionNumber((String)version)).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    public String resolveDynamicCoordinateVersion(GradleCoordinate coordinate, Project project) {
        String version;
        IntellijLintClient client;
        PreciseRevision latest;
        String filter = coordinate.getFullRevision();
        if (!filter.endsWith("+")) {
            return filter;
        }
        filter = filter.substring(0, filter.length() - 1);
        String libraryCoordinate = this.getLibraryCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), filter, false);
        if (libraryCoordinate != null) {
            return libraryCoordinate;
        }
        libraryCoordinate = this.getLibraryCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), filter, true);
        if (libraryCoordinate != null) {
            return libraryCoordinate;
        }
        GradleCoordinate found = GradleUtil.findLatestVersionInGradleCache(coordinate, filter, project);
        if (found != null) {
            return found.getFullRevision();
        }
        if (project != null && (latest = GradleDetector.getLatestVersionFromRemoteRepo((LintClient)(client = new IntellijLintClient(project)), (GradleCoordinate)coordinate, (boolean)coordinate.isPreview())) != null && (version = latest.toShortString()).startsWith(filter)) {
            return version;
        }
        return null;
    }

    protected AndroidSdkData tryToChooseAndroidSdk() {
        return AndroidSdkUtils.tryToChooseAndroidSdk();
    }

    protected String readTextFile(File file) {
        return TemplateUtils.readTextFromDisk(file);
    }

    protected boolean fileExists(File file) {
        return file.exists();
    }

    static class RepositoryLibrary {
        public final String id;
        public final String basePath;
        public final String baseCoordinate;
        private final RangeMap<Integer, String> myArchiveExtensions;

        private RepositoryLibrary(String id, String basePath, String baseCoordinate, String archiveExtension) {
            this.id = id;
            this.basePath = basePath;
            this.baseCoordinate = baseCoordinate;
            this.myArchiveExtensions = TreeRangeMap.create();
            this.myArchiveExtensions.put(Range.all(), (Object)archiveExtension);
        }

        private RepositoryLibrary(String id, String basePath, String baseCoordinate, RangeMap<Integer, String> archiveExtensions) {
            this.id = id;
            this.basePath = basePath;
            this.baseCoordinate = baseCoordinate;
            this.myArchiveExtensions = archiveExtensions;
        }

        public String getArchiveExtension(int revision) {
            String extension = (String)this.myArchiveExtensions.get((Comparable)Integer.valueOf(revision));
            return extension == null ? "" : extension;
        }
    }
}

