/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.ui.ProportionalLayout;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.AbstractCollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class ServicePanelBuilder {
    private final JPanel myRootPanel;
    private final BindingsManager myBindings = new BindingsManager();
    private final Stack<UiGrid> myGrids = new Stack();

    public ServicePanelBuilder() {
        this.myRootPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myRootPanel.putClientProperty("bindings", this.myBindings);
    }

    public JPanel getPanel() {
        assert (this.myGrids.isEmpty()) : "startGrid called without matching endGrid";
        return this.myRootPanel;
    }

    public BindingsManager getBindings() {
        return this.myBindings;
    }

    public JPanel startGrid(String colDefinitions) {
        UiGrid uiGrid = new UiGrid(colDefinitions);
        this.myGrids.push((Object)uiGrid);
        return uiGrid.getPanel();
    }

    public void endGrid() {
        assert (!this.myGrids.isEmpty()) : "endGrid called without matching startGrid";
        this.addComponent(((UiGrid)this.myGrids.pop()).getPanel());
    }

    public void setRow(int row) {
        assert (!this.myGrids.isEmpty()) : "setRow called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrRow(row);
    }

    public void setCol(int col) {
        assert (!this.myGrids.isEmpty()) : "setCol called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrCol(col);
    }

    public JButton addButton() {
        JButton button = new JButton();
        this.addComponent(button);
        return button;
    }

    public JCheckBox addCheckbox() {
        JCheckBox checkbox = new JCheckBox();
        this.addComponent(checkbox);
        return checkbox;
    }

    public JLabel addLabel() {
        JLabel label = new JLabel();
        this.addComponent(label);
        return label;
    }

    public HyperlinkLabel addLink(String text, final URI uri) {
        HyperlinkLabel linkLabel = new HyperlinkLabel(text);
        linkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.addComponent((JComponent)linkLabel);
        return linkLabel;
    }

    public JTextField addField() {
        JTextField field = new JTextField();
        this.addComponent(field);
        return field;
    }

    public JComboBox addComboBox(final ObservableList<String> backingList) {
        AbstractCollectionComboBoxModel<String> model = new AbstractCollectionComboBoxModel<String>(null){

            protected List<String> getItems() {
                return backingList;
            }
        };
        ComboBox comboBox = new ComboBox((ComboBoxModel)model);
        InvalidationListener onListModified = new InvalidationListener((AbstractCollectionComboBoxModel)model, backingList, comboBox){
            final /* synthetic */ AbstractCollectionComboBoxModel val$model;
            final /* synthetic */ ObservableList val$backingList;
            final /* synthetic */ ComboBox val$comboBox;
            {
                this.val$model = abstractCollectionComboBoxModel;
                this.val$backingList = observableList;
                this.val$comboBox = comboBox;
            }

            @Override
            protected void onInvalidated(Observable sender) {
                this.val$model.update();
                if (this.val$backingList.size() > 0 && this.val$comboBox.getSelectedIndex() < 0) {
                    this.val$comboBox.setSelectedIndex(0);
                }
            }
        };
        this.addComponent((JComponent)comboBox);
        backingList.addWeakListener(onListModified);
        comboBox.putClientProperty((Object)"onListModified", (Object)onListModified);
        return comboBox;
    }

    private void addComponent(JComponent component) {
        if (!this.myGrids.isEmpty()) {
            ((UiGrid)this.myGrids.peek()).addComponent(component);
        } else {
            this.myRootPanel.add(component);
        }
    }

    private static class UiGrid {
        private final JPanel myPanel;
        private final int myNumCols;
        private int myCurrCol;
        private int myCurrRow;

        public UiGrid(String colDefinitions) {
            ProportionalLayout layout = ProportionalLayout.fromString(colDefinitions);
            this.myNumCols = layout.getNumColumns();
            this.myPanel = new JPanel(layout);
        }

        public JPanel getPanel() {
            return this.myPanel;
        }

        public void setCurrCol(int col) {
            if (col >= this.myNumCols) {
                throw new IllegalArgumentException(String.format("Can't set col = %1$d on a grid with only %2$d columns", col, this.myNumCols));
            }
            this.myCurrCol = col;
        }

        public void setCurrRow(int row) {
            this.myCurrRow = row;
        }

        public void addComponent(JComponent component) {
            this.myPanel.add((Component)component, new ProportionalLayout.Constraint(this.myCurrRow, this.myCurrCol));
            this.myCurrRow = 0;
            this.myCurrCol = 0;
        }
    }
}

