/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidImportProjectAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectSettingsGroup;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.startup.AndroidCodeStyleSettingsModifier;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.utils.Pair;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.actions.TemplateProjectSettingsGroup;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public class GradleSpecificInitializer
implements Runnable {
    public static final int GRADLE_DAEMON_TIMEOUT_MS = -1;
    private static final Logger LOG;
    public static final String ENABLE_EXPERIMENTAL_ACTIONS = "enable.experimental.actions";
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS;
    private static Set<String> unwantedIntentions;

    @Override
    public void run() {
        CodeStyleSettings settings;
        GradleSpecificInitializer.setUpNewProjectActions();
        GradleSpecificInitializer.setUpWelcomeScreenActions();
        GradleSpecificInitializer.replaceProjectPopupActions();
        GradleSpecificInitializer.checkInstallPath();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction pluginAction = actionManager.getAction("StartupWizard");
        pluginAction.getTemplatePresentation().setVisible(false);
        try {
            GradleSpecificInitializer.setupSdks();
        }
        catch (Exception e) {
            LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
        }
        GradleSpecificInitializer.registerAppClosing();
        CodeStyleScheme scheme = CodeStyleSchemes.getInstance().getDefaultScheme();
        if (scheme != null && (settings = scheme.getCodeStyleSettings()) != null) {
            AndroidCodeStyleSettingsModifier.modify(settings);
        }
        GradleSpecificInitializer.checkAndSetAndroidSdkSources();
        GradleSpecificInitializer.hideUnwantedIntentions();
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            final Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

                public void appStarting(Project project) {
                    app.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
                            Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message, NotificationType.ERROR);
                            notification.setImportant(true);
                            Notifications.Bus.notify((Notification)notification);
                        }
                    });
                }
            });
        }
    }

    private static void setUpNewProjectActions() {
        Actions.replaceAction("OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction("NewProject", new AndroidNewProjectAction());
        Actions.replaceAction("NewModule", new AndroidNewModuleAction());
        Actions.replaceAction("NewModuleInGroup", new AndroidNewModuleInGroupAction());
        Actions.replaceAction("ImportProject", new AndroidImportProjectAction());
        Actions.replaceAction("CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.replaceAction("ImportModule", new AndroidImportModuleAction());
        Actions.hideAction("GenerateAntBuild");
        Actions.hideAction("AddFrameworkSupport");
        Actions.hideAction("BuildArtifact");
        Actions.hideAction("RunTargetAction");
    }

    private static void setUpWelcomeScreenActions() {
        AnAction child;
        DefaultActionGroup settingsGroup;
        AnAction[] children;
        AnAction configureIdeaAction;
        Actions.replaceAction("WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open an existing Android Studio project"));
        Actions.replaceAction("WelcomeScreen.CreateNewProject", new AndroidNewProjectAction("Start a new Android Studio project"));
        Actions.replaceAction("WelcomeScreen.ImportProject", new AndroidImportProjectAction("Import project (Eclipse ADT, Gradle, etc.)"));
        Actions.replaceAction("TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.moveAction("WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "WelcomeScreen.GetFromVcs"));
        ActionManager actionManager = ActionManager.getInstance();
        AnAction getFromVcsAction = actionManager.getAction("WelcomeScreen.GetFromVcs");
        if (getFromVcsAction != null) {
            getFromVcsAction.getTemplatePresentation().setText("Check out project from Version Control");
        }
        if ((configureIdeaAction = actionManager.getAction("WelcomeScreen.Configure.IDEA")) instanceof DefaultActionGroup && (children = (settingsGroup = (DefaultActionGroup)configureIdeaAction).getChildren(null)).length == 1 && (child = children[0]) instanceof TemplateProjectSettingsGroup) {
            settingsGroup.replaceAction(child, (AnAction)new AndroidTemplateProjectSettingsGroup());
        }
    }

    private static void replaceProjectPopupActions() {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of((Object)null, (Object)ActionManager.getInstance().getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action = (AnAction)entry.getSecond();
            if (action instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
                continue;
            }
            if (!(action instanceof MarkRootGroup)) continue;
            parent.remove(action);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        final String message = AndroidBundle.message("android.invalid.sdk.message", new Object[0]);
        NotificationListener.Adapter listener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                ActionManager actionManager = ActionManager.getInstance();
                AnAction sdkManagerAction = actionManager.getAction("Android.RunAndroidSdkManager");
                sdkManagerAction.actionPerformed(null);
                notification.expire();
            }
        };
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter((NotificationListener)listener){
            final /* synthetic */ NotificationListener val$listener;
            {
                this.val$listener = notificationListener;
            }

            public void appStarting(Project project) {
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message, NotificationType.WARNING, val$listener);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    }
                });
            }
        });
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group == null) {
            group = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true);
        }
        return group;
    }

    private static void setupSdks() {
        File androidHome = IdeSdks.getAndroidSdkPath();
        if (androidHome != null) {
            WizardUtils.ValidationResult sdkValidationResult = WizardUtils.validateLocation(androidHome.getAbsolutePath(), "Android SDK location", false, false);
            if (sdkValidationResult.isError()) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return;
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            return;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstCompatibleAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            IdeSdks.createAndroidSdkPerAndroidTarget(new File(FileUtil.toSystemDependentName((String)sdkHomePath)));
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
                if (androidSdkPath == null) {
                    return;
                }
                FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
                boolean promptSdkSelection = wizardMode == null;
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
                if (sdk != null && sdk.getName().startsWith("Android ")) {
                    Sdk jdk;
                    SdkModificator sdkModificator = sdk.getSdkModificator();
                    sdkModificator.setName("Android " + sdk.getName().substring("Android ".length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    IdeSdks.createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    private static Sdk findFirstCompatibleAndroidSdk() {
        List<Sdk> sdks = AndroidSdkUtils.getAllAndroidSdks();
        for (Sdk sdk : sdks) {
            String sdkPath = sdk.getHomePath();
            if (!VersionCheck.isCompatibleVersion(sdkPath)) continue;
            return sdk;
        }
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    private static File getAndroidSdkPath() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        String androidHomeValue = System.getenv("ANDROID_HOME");
        String msg = String.format("Checking if ANDROID_HOME is set: '%1$s' is '%2$s'", "ANDROID_HOME", androidHomeValue);
        LOG.info(msg);
        if (!StringUtil.isEmpty((String)androidHomeValue) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue)) {
            LOG.info("Using Android SDK specified by the environment variable.");
            return new File(FileUtil.toSystemDependentName((String)androidHomeValue));
        }
        String sdkPath = GradleSpecificInitializer.getLastSdkPathUsedByAndroidTools();
        msg = !StringUtil.isEmpty((String)sdkPath) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue) ? String.format("Last SDK used by Android tools: '%1$s'", sdkPath) : "Unable to locate last SDK used by Android tools";
        LOG.info(msg);
        return sdkPath == null ? null : new File(FileUtil.toSystemDependentName((String)sdkPath));
    }

    private static String getLastSdkPathUsedByAndroidTools() {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return null;
        }
        File file = new File(new File(userHome, ".android"), "ddms.cfg");
        if (!file.exists()) {
            return null;
        }
        try {
            Properties properties = PropertiesUtil.getProperties(file);
            return properties.getProperty("lastSdkPath");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void registerAppClosing() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            public void appClosing() {
                try {
                    DefaultGradleConnector.close();
                }
                catch (RuntimeException e) {
                    LOG.info("Failed to stop Gradle daemons during IDE shutdown", (Throwable)e);
                }
            }
        });
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(Sdk sdk) {
        VirtualFile[] storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (storedSources.length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            IAndroidTarget target = platform.getTarget();
            AndroidSdkUtils.findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    private static void hideUnwantedIntentions() {
        IntentionManager intentionManager = IntentionManager.getInstance();
        if (!(intentionManager instanceof IntentionManagerImpl)) {
            return;
        }
        while (((IntentionManagerImpl)intentionManager).hasActiveRequests()) {
            TimeoutUtil.sleep((long)100L);
        }
        for (IntentionAction intentionAction : intentionManager.getIntentionActions()) {
            if (!unwantedIntentions.contains(intentionAction.getClass().getSimpleName())) continue;
            intentionManager.unregisterIntention(intentionAction);
        }
    }

    static {
        System.setProperty("external.system.remote.process.idle.ttl.ms", String.valueOf(-1));
        LOG = Logger.getInstance(GradleSpecificInitializer.class);
        ANDROID_SDK_RELATIVE_PATHS = new String[]{ANDROID_SDK_FOLDER_NAME, File.separator + ".." + File.separator + ANDROID_SDK_FOLDER_NAME};
        unwantedIntentions = Sets.newHashSet((Object[])new String[]{"TestNGOrderEntryFix", "JCiPOrderEntryFix"});
    }
}

