/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.utils.Pair;
import java.util.Properties;
import org.w3c.dom.Node;

public class LayoutlibVersionMixin {
    public static final int LAYOUTLIB_API_NOT_SPECIFIED = 0;
    public static final int LAYOUTLIB_REV_NOT_SPECIFIED = 0;
    private final Pair<Integer, Integer> mLayoutlibVersion;

    public LayoutlibVersionMixin(Node pkgNode) {
        int api = 0;
        int rev = 0;
        Node layoutlibNode = RemotePackageParserUtils.findChildElement(pkgNode, "layoutlib");
        if (layoutlibNode != null) {
            api = RemotePackageParserUtils.getXmlInt(layoutlibNode, "api", 0);
            rev = RemotePackageParserUtils.getXmlInt(layoutlibNode, "revision", 0);
        }
        this.mLayoutlibVersion = Pair.of((Object)api, (Object)rev);
    }

    void saveProperties(Properties props) {
        if ((Integer)this.mLayoutlibVersion.getFirst() != 0) {
            props.setProperty("Layoutlib.Api", ((Integer)this.mLayoutlibVersion.getFirst()).toString());
            props.setProperty("Layoutlib.Revision", ((Integer)this.mLayoutlibVersion.getSecond()).toString());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mLayoutlibVersion.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutlibVersionMixin)) {
            return false;
        }
        LayoutlibVersionMixin other = (LayoutlibVersionMixin)obj;
        return this.mLayoutlibVersion.equals(other.mLayoutlibVersion);
    }
}

