/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ManualTargetChooser;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetPickerDialog;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;

public class ShowChooserTarget
extends DeployTarget<State> {
    private DeployTargetPickerDialog.Result myResult;

    @Override
    public String getId() {
        return TargetSelectionMode.SHOW_DIALOG.name();
    }

    @Override
    public String getDisplayName() {
        return "Show Device Chooser Dialog";
    }

    @Override
    public State createState() {
        return new State();
    }

    @Override
    public boolean requiresRuntimePrompt(State deployTargetState) {
        return true;
    }

    @Override
    public boolean showPrompt(Executor executor, ExecutionEnvironment env, AndroidFacet facet, DeviceCount deviceCount, boolean androidTests, Map<String, DeployTargetState> deployTargetStates, int runConfigId, ProcessHandlerConsolePrinter printer) {
        State showChooserState = (State)deployTargetStates.get(this.getId());
        List<DeployTarget> applicableTargets = ShowChooserTarget.getTargetsProvidingRunProfileState(executor, androidTests);
        if (applicableTargets.isEmpty()) {
            DeviceTarget deviceTarget = new ManualTargetChooser(showChooserState, facet, runConfigId).getTarget(printer, deviceCount, executor instanceof DefaultDebugExecutor);
            if (deviceTarget == null) {
                return false;
            }
            this.myResult = DeployTargetPickerDialog.Result.create(deviceTarget);
            return true;
        }
        DeployTargetPickerDialog dialog = new DeployTargetPickerDialog(runConfigId, facet, applicableTargets, deployTargetStates, printer);
        if (dialog.showAndGet()) {
            this.myResult = dialog.getResult();
            return true;
        }
        return false;
    }

    private static List<DeployTarget> getTargetsProvidingRunProfileState(Executor executor, boolean androidTests) {
        ArrayList targets = Lists.newArrayList();
        for (DeployTarget target : DeployTarget.getDeployTargets()) {
            if (!target.showInDevicePicker() || !target.isApplicable(androidTests) || !target.hasCustomRunProfileState(executor)) continue;
            targets.add(target);
        }
        return targets;
    }

    @Override
    public DeployTargetConfigurable createConfigurable(Project project, Disposable parentDisposable, DeployTargetConfigurableContext context) {
        return new ShowChooserConfigurable();
    }

    @Override
    public boolean hasCustomRunProfileState(Executor executor) {
        return this.myResult != null && this.myResult.hasRunProfile();
    }

    @Override
    public RunProfileState getRunProfileState(Executor executor, ExecutionEnvironment env, State state) throws ExecutionException {
        return this.myResult.getRunProfileState(executor, env, state);
    }

    @Override
    public DeviceTarget getTarget(State state, AndroidFacet facet, DeviceCount deviceCount, boolean debug, int runConfigId, ConsolePrinter printer) {
        return this.myResult.getDeviceTarget();
    }

    private static class ShowChooserConfigurable
    implements DeployTargetConfigurable<State> {
        private final JBCheckBox myCheckbox = new JBCheckBox("Use same device for future launches");

        @Override
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        @Override
        public void resetFrom(State state, int uniqueID) {
            this.myCheckbox.setSelected(state.USE_LAST_SELECTED_DEVICE);
        }

        @Override
        public void applyTo(State state, int uniqueID) {
            state.USE_LAST_SELECTED_DEVICE = this.myCheckbox.isSelected();
        }
    }

    public static final class State
    extends DeployTargetState {
        public boolean USE_LAST_SELECTED_DEVICE;
    }
}

