/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.EmulatorTargetChooser;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.EmulatorTargetConfigurable;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class EmulatorTarget
extends DeployTarget<State> {
    @Override
    public String getId() {
        return TargetSelectionMode.EMULATOR.name();
    }

    @Override
    public String getDisplayName() {
        return "Emulator";
    }

    @Override
    public State createState() {
        return new State();
    }

    @Override
    public DeployTargetConfigurable createConfigurable(Project project, Disposable parentDisposable, DeployTargetConfigurableContext context) {
        return new EmulatorTargetConfigurable(project, parentDisposable, context);
    }

    @Override
    public DeviceTarget getTarget(State state, AndroidFacet facet, DeviceCount deviceCount, boolean debug, int runConfigId, ConsolePrinter printer) {
        return new EmulatorTargetChooser(facet, Strings.emptyToNull((String)state.PREFERRED_AVD)).getTarget(printer, deviceCount, debug);
    }

    public static final class State
    extends DeployTargetState {
        public String PREFERRED_AVD = "";

        @Override
        public List<ValidationError> validate(AndroidFacet facet) {
            if (StringUtil.isEmpty((String)this.PREFERRED_AVD)) {
                return ImmutableList.of();
            }
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
            }
            AvdInfo avdInfo = avdManager.getAvd(this.PREFERRED_AVD, false);
            if (avdInfo == null) {
                return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.PREFERRED_AVD)));
            }
            if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
                String message = avdInfo.getErrorMessage();
                message = AndroidBundle.message("avd.not.valid.error", this.PREFERRED_AVD) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
                return ImmutableList.of((Object)ValidationError.fatal(message));
            }
            return ImmutableList.of();
        }
    }
}

