/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceComparator;
import com.android.tools.idea.run.AndroidDeviceRenderer;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DeviceReadyListener;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.LaunchCompatibiltyChecker;
import com.android.tools.idea.run.LaunchUtils;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;

public class DevicePicker
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable,
ActionListener {
    private static final Logger LOG = Logger.getInstance(DevicePicker.class);
    private static final int UPDATE_DELAY_MILLIS = 250;
    private JPanel myPanel;
    private JButton myCreateEmulatorButton;
    private HyperlinkLabel myHelpHyperlink;
    private JScrollPane myScrollPane;
    private JBList myDevicesList;
    private final AndroidFacet myFacet;
    private final SortedListModel<AndroidDevice> myModel;
    private final MergingUpdateQueue myUpdateQueue;
    private List<AvdInfo> myAvdInfos;

    public DevicePicker(Disposable parent, final AndroidFacet facet) {
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myHelpHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                BrowserUtil.browse((String)"http://developer.android.com/tools/device.html", (Project)facet.getModule().getProject());
            }
        });
        this.myModel = SortedListModel.create((Comparator)new AndroidDeviceComparator());
        this.myDevicesList.setModel(this.myModel);
        this.myDevicesList.setCellRenderer((ListCellRenderer)((Object)new AndroidDeviceRenderer(DevicePicker.createChecker(facet))));
        this.myDevicesList.setSelectionMode(0);
        this.myCreateEmulatorButton.addActionListener(this);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.postUpdate();
        this.refreshAvds();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    private static LaunchCompatibiltyChecker createChecker(AndroidFacet facet) {
        AndroidVersion minSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet.getModule().getName());
        }
        EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures = LaunchUtils.isWatchFeatureRequired(facet) ? EnumSet.of(IDevice.HardwareFeature.WATCH) : EnumSet.noneOf(IDevice.HardwareFeature.class);
        return new LaunchCompatibiltyChecker(minSdkVersion, platform.getTarget(), requiredHardwareFeatures);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicesList;
    }

    private void createUIComponents() {
        this.myDevicesList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDevicesList);
        this.myHelpHyperlink = new HyperlinkLabel("Don't see your device?");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myCreateEmulatorButton) {
            AvdEditWizard wizard = new AvdEditWizard(this.myPanel, this.myFacet.getModule().getProject(), this.myFacet.getModule(), null, false);
            wizard.init();
            wizard.showAndGet();
            this.refreshAvds();
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(IDevice device) {
        this.postUpdate();
    }

    public void deviceDisconnected(IDevice device) {
        this.postUpdate();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.postUpdate();
    }

    private void refreshAvds() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final List<AvdInfo> avdInfos = AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DevicePicker.this.myAvdInfos = avdInfos;
                        DevicePicker.this.updateModel();
                    }
                });
            }
        });
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateDevicePickerModel"){

            public void run() {
                DevicePicker.this.updateModel();
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private void updateModel() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    DevicePicker.this.updateModel();
                }
            });
            return;
        }
        Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValues());
        HashSet runningAvdNames = Sets.newHashSet();
        this.myModel.clear();
        for (IDevice device : AndroidDebugBridge.getBridge().getDevices()) {
            String avdName;
            this.myModel.add((Object)new ConnectedAndroidDevice(device, this.myAvdInfos));
            if (!device.isEmulator() || (avdName = device.getAvdName()) == null) continue;
            runningAvdNames.add(avdName);
        }
        if (this.myAvdInfos != null) {
            for (AvdInfo avdInfo : this.myAvdInfos) {
                if (runningAvdNames.contains(avdInfo.getName())) continue;
                this.myModel.add((Object)new LaunchableAndroidDevice(avdInfo));
            }
        }
        this.myDevicesList.setSelectedIndices(DevicePicker.getIndices(this.myModel.getItems(), selectedSerials));
    }

    private static int[] getIndices(List<AndroidDevice> items, Set<String> selectedSerials) {
        TIntArrayList list = new TIntArrayList(selectedSerials.size());
        for (int i = 0; i < items.size(); ++i) {
            if (!selectedSerials.contains(items.get(i).getSerial())) continue;
            list.add(i);
        }
        return list.toNativeArray();
    }

    private static Set<String> getSelectedSerials(Object[] selectedValues) {
        HashSet selection = Sets.newHashSet();
        for (Object o : selectedValues) {
            if (!(o instanceof AndroidDevice)) continue;
            selection.add(((AndroidDevice)o).getSerial());
        }
        return selection;
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public ValidationInfo validate() {
        if (this.getSelectedDevice() == null) {
            return new ValidationInfo("No device selected", (JComponent)this.myDevicesList);
        }
        return null;
    }

    public AndroidDevice getSelectedDevice() {
        return (AndroidDevice)this.myDevicesList.getSelectedValue();
    }

    public DeviceTarget getSelectedTarget(ProcessHandlerConsolePrinter printer) {
        AndroidDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            throw new IllegalStateException("Incorrect validation? No target was selected in device picker.");
        }
        if (selectedDevice instanceof ConnectedAndroidDevice) {
            IDevice device = ((ConnectedAndroidDevice)selectedDevice).getDevice();
            return DeviceTarget.forDevices(Collections.singletonList(device));
        }
        if (selectedDevice instanceof LaunchableAndroidDevice) {
            AvdInfo avdInfo = ((LaunchableAndroidDevice)selectedDevice).getAvdInfo();
            AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(this.myFacet.getModule().getProject(), avdInfo);
            final String avdName = avdInfo.getName();
            Predicate<IDevice> avdNameFilter = new Predicate<IDevice>(){

                public boolean apply(IDevice device) {
                    return device.isEmulator() && avdName.equals(device.getAvdName());
                }
            };
            return DeviceTarget.forFuture(DeviceReadyListener.getReadyDevice(avdNameFilter, printer));
        }
        throw new IllegalStateException("Unsupported ");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "South");
        this.myCreateEmulatorButton = jButton = new JButton();
        jButton.setText("Create New Emulator");
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHelpHyperlink;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JScrollPane jScrollPane = this.myScrollPane;
        jPanel.add((Component)jScrollPane, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

