/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.DevicePicker;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.android.facet.AndroidFacet;

public class DeployTargetPickerDialog
extends DialogWrapper {
    private static final int DEVICE_TAB_INDEX = 0;
    private static final int CUSTOM_RUNPROFILE_PROVIDER_TARGET_INDEX = 1;
    private final int myContextId;
    private final AndroidFacet myFacet;
    private final DeployTarget myDeployTarget;
    private final DeployTargetState myDeployTargetState;
    private final DeployTargetConfigurable myDeployTargetConfigurable;
    private final DevicePicker myDevicePicker;
    private final ProcessHandlerConsolePrinter myPrinter;
    private JPanel myContentPane;
    private JBTabbedPane myTabbedPane;
    private JPanel myCloudTargetsPanel;
    private JPanel myDevicesPanel;
    private Result myResult;

    public DeployTargetPickerDialog(int runContextId, AndroidFacet facet, List<DeployTarget> deployTargets, Map<String, DeployTargetState> deployTargetStates, ProcessHandlerConsolePrinter printer) {
        super(facet.getModule().getProject(), true);
        this.$$$setupUI$$$();
        if (deployTargets.size() != 1) {
            throw new IllegalArgumentException("Only 1 custom run profile state provider can be displayed right now..");
        }
        this.myFacet = facet;
        this.myContextId = runContextId;
        this.myDeployTarget = deployTargets.get(0);
        this.myDeployTargetState = deployTargetStates.get(this.myDeployTarget.getId());
        this.myPrinter = printer;
        this.myDevicePicker = new DevicePicker(this.getDisposable(), facet);
        this.myDevicesPanel.add((Component)this.myDevicePicker.getComponent(), "Center");
        this.myDevicesPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        Module module = facet.getModule();
        this.myDeployTargetConfigurable = this.myDeployTarget.createConfigurable(module.getProject(), this.getDisposable(), new Context(module));
        JComponent component = this.myDeployTargetConfigurable.createComponent();
        if (component != null) {
            this.myCloudTargetsPanel.add((Component)component, "Center");
        }
        this.myDeployTargetConfigurable.resetFrom(this.myDeployTargetState, this.myContextId);
        this.setTitle("Select Deployment Target");
        this.setModal(true);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    protected String getDimensionServiceKey() {
        return "deploy.picker.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicePicker.getPreferredFocusedComponent();
    }

    protected ValidationInfo doValidate() {
        if (this.myTabbedPane.getSelectedIndex() == 1) {
            this.myDeployTargetConfigurable.applyTo(this.myDeployTargetState, this.myContextId);
            List<ValidationError> errors = this.myDeployTargetState.validate(this.myFacet);
            if (!errors.isEmpty()) {
                return new ValidationInfo(errors.get(0).getMessage(), null);
            }
        } else {
            return this.myDevicePicker.validate();
        }
        return super.doValidate();
    }

    protected Alarm.ThreadToUse getValidationThreadToUse() {
        return Alarm.ThreadToUse.SWING_THREAD;
    }

    protected void doOKAction() {
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            this.myResult = Result.create(this.myDevicePicker.getSelectedTarget(this.myPrinter));
        } else if (selectedIndex == 1) {
            this.myResult = Result.create(this.myDeployTarget, this.myDeployTargetState);
        }
        super.doOKAction();
    }

    public Result getResult() {
        return this.myResult;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel3;
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel3.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDevicesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Devices", null, jPanel2, null);
        JBPanel jBPanel = new JBPanel();
        jBPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Cloud Testing", null, (Component)jBPanel, null);
        this.myCloudTargetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBPanel.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jBPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static final class Context
    implements DeployTargetConfigurableContext {
        private final Module myModule;

        public Context(Module module) {
            this.myModule = module;
        }

        @Override
        public Module getModule() {
            return this.myModule;
        }

        @Override
        public void addModuleChangeListener(ActionListener listener) {
        }

        @Override
        public void removeModuleChangeListener(ActionListener listener) {
        }
    }

    private static class DeviceResult
    extends Result {
        private final DeviceTarget myTarget;

        private DeviceResult(DeviceTarget target) {
            this.myTarget = target;
        }

        @Override
        public boolean hasRunProfile() {
            return false;
        }

        @Override
        public DeviceTarget getDeviceTarget() {
            return this.myTarget;
        }
    }

    private static class RunProfileResult
    extends Result {
        private final DeployTarget myDelegate;
        private final DeployTargetState myDelegateState;

        private RunProfileResult(DeployTarget delegate, DeployTargetState state) {
            this.myDelegate = delegate;
            this.myDelegateState = state;
        }

        @Override
        public boolean hasRunProfile() {
            return true;
        }

        @Override
        public RunProfileState getRunProfileState(Executor executor, ExecutionEnvironment env, DeployTargetState state) throws ExecutionException {
            return this.myDelegate.getRunProfileState(executor, env, this.myDelegateState);
        }
    }

    public static abstract class Result {
        public boolean hasRunProfile() {
            return false;
        }

        public RunProfileState getRunProfileState(Executor executor, ExecutionEnvironment env, DeployTargetState state) throws ExecutionException {
            throw new IllegalStateException();
        }

        public DeviceTarget getDeviceTarget() {
            throw new IllegalStateException();
        }

        public static Result create(DeployTarget deployTarget, DeployTargetState deployTargetState) {
            return new RunProfileResult(deployTarget, deployTargetState);
        }

        public static Result create(DeviceTarget device) {
            return new DeviceResult(device);
        }
    }
}

