/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurableWrapper;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.RunConfigurationEditorContext;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private JBLabel myModuleJBLabel;
    private JComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private ConfigurableCardPanel myDeployTargetConfigurableCardPanel;
    private ComboBox myDeploymentTargetCombo;
    private JCheckBox myClearLogCheckBox;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox mySkipNoOpApkInstallation;
    private JCheckBox myForceStopRunningApplicationCheckBox;
    private JComponent anchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;
    private final ImmutableMap<String, DeployTargetConfigurableWrapper> myDeployTargetConfigurables;
    private final List<DeployTarget> myApplicableDeployTargets;

    public AndroidRunConfigurationEditor(Project project, final Predicate<AndroidFacet> libraryProjectValidator, T config) {
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) {
                    return false;
                }
                return !facet.isLibraryProject() || libraryProjectValidator.apply((Object)facet);
            }
        };
        this.myApplicableDeployTargets = ImmutableList.copyOf(((AndroidRunConfigurationBase)((Object)config)).getApplicableDeployTargets());
        RunConfigurationEditorContext context = new RunConfigurationEditorContext(this.myModuleSelector, this.myModulesComboBox);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTarget target : this.myApplicableDeployTargets) {
            builder.put((Object)target.getId(), (Object)new DeployTargetConfigurableWrapper(project, (Disposable)this, context, target));
        }
        this.myDeployTargetConfigurables = builder.build();
        this.myDeploymentTargetCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(this.myApplicableDeployTargets));
        this.myDeploymentTargetCombo.setRenderer((ListCellRenderer)((Object)new DeployTarget.Renderer()));
        this.myDeploymentTargetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeployTarget target = (DeployTarget)AndroidRunConfigurationEditor.this.myDeploymentTargetCombo.getSelectedItem();
                AndroidRunConfigurationEditor.this.myDeployTargetConfigurableCardPanel.select(AndroidRunConfigurationEditor.this.myDeployTargetConfigurables.get((Object)target.getId()), true);
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AndroidRunConfigurationEditor.this.mySkipNoOpApkInstallation == e.getSource()) {
                    AndroidRunConfigurationEditor.this.myForceStopRunningApplicationCheckBox.setEnabled(AndroidRunConfigurationEditor.this.mySkipNoOpApkInstallation.isSelected());
                }
            }
        };
        this.mySkipNoOpApkInstallation.addActionListener(actionListener);
    }

    public void setConfigurationSpecificEditor(ConfigurationSpecificEditor<T> configurationSpecificEditor) {
        this.myConfigurationSpecificEditor = configurationSpecificEditor;
        this.myConfigurationSpecificPanel.add(configurationSpecificEditor.getComponent());
        this.setAnchor(this.myConfigurationSpecificEditor.getAnchor());
        this.myShowLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    protected void resetEditorFrom(T configuration) {
        this.myModuleSelector.reset(configuration);
        this.myDeploymentTargetCombo.setSelectedItem((Object)((AndroidRunConfigurationBase)((Object)configuration)).getCurrentDeployTarget());
        for (DeployTarget target : this.myApplicableDeployTargets) {
            DeployTargetState state = ((AndroidRunConfigurationBase)((Object)configuration)).getDeployTargetState(target);
            ((DeployTargetConfigurableWrapper)this.myDeployTargetConfigurables.get((Object)target.getId())).resetFrom(state, configuration.getUniqueID());
        }
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY);
        this.mySkipNoOpApkInstallation.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).SKIP_NOOP_APK_INSTALLATIONS);
        this.myForceStopRunningApplicationCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).FORCE_STOP_RUNNING_APP);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
    }

    protected void applyEditorTo(T configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo(configuration);
        ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode((DeployTarget)this.myDeploymentTargetCombo.getSelectedItem());
        for (DeployTarget target : this.myApplicableDeployTargets) {
            DeployTargetState state = ((AndroidRunConfigurationBase)((Object)configuration)).getDeployTargetState(target);
            ((DeployTargetConfigurableWrapper)this.myDeployTargetConfigurables.get((Object)target.getId())).applyTo(state, configuration.getUniqueID());
        }
        ((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).SKIP_NOOP_APK_INSTALLATIONS = this.mySkipNoOpApkInstallation.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).FORCE_STOP_RUNNING_APP = this.myForceStopRunningApplicationCheckBox.isSelected();
        this.myConfigurationSpecificEditor.applyTo(configuration);
    }

    protected JComponent createEditor() {
        return this.myPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        ConfigurableCardPanel configurableCardPanel;
        ComboBox comboBox;
        JPanel jPanel;
        JComboBox jComboBox;
        JBLabel jBLabel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Deployment Target Options");
        jPanel3.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Target:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        this.myDeploymentTargetCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDeployTargetConfigurableCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        jPanel3.add((Component)configurableCardPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 4));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.misc.tab.title"), null, jPanel4, null);
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logcat", 0, 0, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClearLogCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.skip.content.label"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Show logcat automatically");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Installation Options", 0, 0, null, null));
        this.mySkipNoOpApkInstallation = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Skip installation if APK has not changed");
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel6.add((Component)spacer7, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myForceStopRunningApplicationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Force stop running application before launching activity");
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

