/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class DefaultActivityLocator
extends ActivityLocator {
    private final AndroidFacet myFacet;

    public DefaultActivityLocator(AndroidFacet facet) {
        this.myFacet = facet;
    }

    @Override
    public String getQualifiedActivityName(IDevice device) throws ActivityLocator.ActivityLocatorException {
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, device);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        return activity;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, null);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    static String computeDefaultActivity(AndroidFacet facet, final IDevice device) {
        assert (!facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        final ManifestInfo manifestInfo = ManifestInfo.get(facet.getModule(), ActivityLocatorUtils.shouldUseMergedManifest(facet));
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DefaultActivityLocator.computeDefaultActivity(manifestInfo.getActivities(), manifestInfo.getActivityAliases(), device);
            }
        });
    }

    public static String getDefaultLauncherActivityName(final Manifest manifest) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Application application = manifest.getApplication();
                if (application == null) {
                    return null;
                }
                return DefaultActivityLocator.computeDefaultActivity(application.getActivities(), application.getActivityAliass(), null);
            }
        });
    }

    private static String computeDefaultActivity(List<Activity> activities, List<ActivityAlias> activityAliases, IDevice device) {
        ActivityWrapper activity;
        List<ActivityWrapper> launchableActivities = DefaultActivityLocator.getLaunchableActivities(DefaultActivityLocator.merge(activities, activityAliases));
        if (launchableActivities.isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        if (device != null && (activity = DefaultActivityLocator.findLauncherActivityForDevice(launchableActivities, device)) != null) {
            return activity.getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    private static ActivityWrapper findLauncherActivityForDevice(List<ActivityWrapper> launchableActivities, IDevice device) {
        if (device.supportsFeature(IDevice.HardwareFeature.TV)) {
            return DefaultActivityLocator.findLeanbackLauncher(launchableActivities);
        }
        return null;
    }

    private static ActivityWrapper findLeanbackLauncher(List<ActivityWrapper> launcherActivities) {
        for (ActivityWrapper activity : launcherActivities) {
            for (IntentFilter filter : activity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, "android.intent.category.LEANBACK_LAUNCHER")) continue;
                return activity;
            }
        }
        return null;
    }

    private static ActivityWrapper findDefaultLauncher(List<ActivityWrapper> launcherActivities) {
        for (ActivityWrapper activity : launcherActivities) {
            for (IntentFilter filter : activity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, "android.intent.category.DEFAULT")) continue;
                return activity;
            }
        }
        return null;
    }

    private static List<ActivityWrapper> getLaunchableActivities(List<ActivityWrapper> allActivities) {
        return ContainerUtil.filter(allActivities, (Condition)new Condition<ActivityWrapper>(){

            public boolean value(ActivityWrapper activity) {
                return ActivityLocatorUtils.containsLauncherIntent(activity.getIntentFilters());
            }
        });
    }

    private static List<ActivityWrapper> merge(List<Activity> activities, List<ActivityAlias> activityAliases) {
        ArrayList activityWrappers = Lists.newArrayListWithExpectedSize((int)(activities.size() + activityAliases.size()));
        for (Activity activity : activities) {
            activityWrappers.add(ActivityWrapper.get(activity));
        }
        for (ActivityAlias activityAlias : activityAliases) {
            activityWrappers.add(ActivityWrapper.get(activityAlias));
        }
        return activityWrappers;
    }

    private static class ActivityAliasWrapper
    extends ActivityWrapper {
        private final ActivityAlias myAlias;

        public ActivityAliasWrapper(ActivityAlias activityAlias) {
            this.myAlias = activityAlias;
        }

        @Override
        public List<IntentFilter> getIntentFilters() {
            return this.myAlias.getIntentFilters();
        }

        @Override
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myAlias);
        }
    }

    private static class RealActivityWrapper
    extends ActivityWrapper {
        private final Activity myActivity;

        public RealActivityWrapper(Activity activity) {
            this.myActivity = activity;
        }

        @Override
        public List<IntentFilter> getIntentFilters() {
            return this.myActivity.getIntentFilters();
        }

        @Override
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    public static abstract class ActivityWrapper {
        public abstract List<IntentFilter> getIntentFilters();

        public abstract String getQualifiedName();

        public static ActivityWrapper get(Activity activity) {
            return new RealActivityWrapper(activity);
        }

        public static ActivityWrapper get(ActivityAlias activityAlias) {
            return new ActivityAliasWrapper(activityAlias);
        }
    }
}

