/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;

public final class ValidationError
implements Comparable<ValidationError> {
    private final Severity mySeverity;
    private final String myMessage;
    private final Runnable myQuickfix;

    private ValidationError(Severity severity, String message, Runnable quickfix) {
        this.mySeverity = severity;
        this.myMessage = message;
        this.myQuickfix = quickfix;
    }

    public static ValidationError fatal(String message) {
        return ValidationError.fatal(message, null);
    }

    public static ValidationError fatal(String message, Runnable quickfix) {
        return new ValidationError(Severity.FATAL, message, quickfix);
    }

    public static ValidationError warning(String message) {
        return ValidationError.warning(message, null);
    }

    public static ValidationError warning(String message, Runnable quickfix) {
        return new ValidationError(Severity.WARNING, message, quickfix);
    }

    public static ValidationError fromException(RuntimeConfigurationException e) {
        if (e instanceof RuntimeConfigurationError) {
            return ValidationError.fatal(e.getMessage(), e.getQuickFix());
        }
        return ValidationError.warning(e.getMessage(), e.getQuickFix());
    }

    public Severity getSeverity() {
        return this.mySeverity;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Runnable getQuickfix() {
        return this.myQuickfix;
    }

    public boolean isFatal() {
        return this.mySeverity.equals((Object)Severity.FATAL);
    }

    @Override
    public int compareTo(ValidationError o) {
        return this.mySeverity.compareTo(o.getSeverity());
    }

    public static enum Severity {
        WARNING,
        FATAL;

    }
}

