/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceStateAtLaunch;
import com.android.tools.idea.run.DeviceStateAtLaunchService;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.EmulatorTargetChooser;
import com.android.tools.idea.run.ExtendedDeviceChooserDialog;
import com.android.tools.idea.run.editor.ShowChooserTarget;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class ManualTargetChooser {
    private static final Logger LOG = Logger.getInstance(ManualTargetChooser.class);
    private final ShowChooserTarget.State myShowChooserState;
    private final AndroidFacet myFacet;
    private final int myRunConfigId;
    private final Project myProject;

    public ManualTargetChooser(ShowChooserTarget.State state, AndroidFacet facet, int runConfigId) {
        this.myShowChooserState = state;
        this.myFacet = facet;
        this.myRunConfigId = runConfigId;
        this.myProject = facet.getModule().getProject();
    }

    public DeviceTarget getTarget(ConsolePrinter printer, DeviceCount deviceCount, boolean debug) {
        Collection<IDevice> devices = this.getReusableDevices(deviceCount);
        if (!devices.isEmpty()) {
            return DeviceTarget.forDevices(devices);
        }
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + this.myFacet.getModule().getName());
            return null;
        }
        ExtendedDeviceChooserDialog chooser = new ExtendedDeviceChooserDialog(this.myFacet, platform.getTarget(), deviceCount.isMultiple(), true, this.myShowChooserState.USE_LAST_SELECTED_DEVICE);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        if (chooser.isToLaunchEmulator()) {
            String selectedAvd = chooser.getSelectedAvd();
            if (selectedAvd == null) {
                return null;
            }
            EmulatorTargetChooser emulatorChooser = new EmulatorTargetChooser(this.myFacet, selectedAvd);
            return emulatorChooser.getTarget(printer, deviceCount, debug);
        }
        Object[] selectedDevices = chooser.getSelectedDevices();
        if (selectedDevices.length == 0) {
            return null;
        }
        DeviceStateAtLaunchService.getInstance(this.myProject).setDevicesUsedInLaunch(this.myRunConfigId, Sets.newHashSet((Object[])selectedDevices), this.getOnlineDevices());
        this.myShowChooserState.USE_LAST_SELECTED_DEVICE = chooser.useSameDevicesAgain();
        return DeviceTarget.forDevices(Arrays.asList(selectedDevices));
    }

    private Collection<IDevice> getReusableDevices(DeviceCount deviceCount) {
        Collection<IDevice> usedDevices;
        DeviceStateAtLaunch devicesToReuse = DeviceStateAtLaunchService.getInstance(this.myProject).getDevicesUsedInLastLaunch(this.myRunConfigId);
        if (!this.myShowChooserState.USE_LAST_SELECTED_DEVICE || devicesToReuse == null) {
            return ImmutableList.of();
        }
        Set<IDevice> onlineDevices = this.getOnlineDevices();
        if (devicesToReuse.matchesCurrentAvailableDevices(onlineDevices) && ((usedDevices = devicesToReuse.filterByUsed(onlineDevices)).size() == 1 || deviceCount.isMultiple())) {
            return usedDevices;
        }
        return ImmutableList.of();
    }

    private Set<IDevice> getOnlineDevices() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
        if (debugBridge == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])debugBridge.getDevices());
    }
}

