/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.run.AndroidDevice;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;

public class LaunchableAndroidDevice
implements AndroidDevice {
    private final AvdInfo myAvdInfo;

    public LaunchableAndroidDevice(AvdInfo avdInfo) {
        this.myAvdInfo = avdInfo;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public AndroidVersion getVersion() {
        IAndroidTarget target = this.myAvdInfo.getTarget();
        return target == null ? AndroidVersion.DEFAULT : target.getVersion();
    }

    @Override
    public String getSerial() {
        return this.myAvdInfo.getName();
    }

    @Override
    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        switch (feature) {
            case WATCH: {
                return AvdWizardConstants.WEAR_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case TV: {
                return AvdWizardConstants.TV_TAG.equals((Object)this.myAvdInfo.getTag());
            }
        }
        return true;
    }

    @Override
    public void renderName(ColoredTextContainer component) {
        component.setIcon(AllIcons.Actions.Execute);
        component.append(AvdManagerConnection.getAvdDisplayName(this.myAvdInfo), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }
}

