/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ErrorMatchingReceiver;

class InstallResult {
    public final FailureCode failureCode;
    public final String failureMessage;
    public final String installOutput;

    public InstallResult(FailureCode failureCode, String failureMessage, String installOutput) {
        this.failureCode = failureCode;
        this.failureMessage = failureMessage;
        this.installOutput = installOutput;
    }

    public static InstallResult forLaunchOutput(ErrorMatchingReceiver receiver) {
        return new InstallResult(InstallResult.getFailureCode(receiver), receiver.getFailureMessage(), receiver.getOutput().toString());
    }

    private static FailureCode getFailureCode(ErrorMatchingReceiver receiver) {
        String failureMessage = receiver.getFailureMessage();
        if (receiver.getErrorType() == -2 && failureMessage == null) {
            return FailureCode.NO_ERROR;
        }
        if ("INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES".equals(failureMessage)) {
            return FailureCode.INCONSISTENT_CERTIFICATES;
        }
        if ("INSTALL_PARSE_FAILED_NO_CERTIFICATES".equals(failureMessage)) {
            return FailureCode.NO_CERTIFICATE;
        }
        if ("INSTALL_FAILED_VERSION_DOWNGRADE".equals(failureMessage)) {
            return FailureCode.INSTALL_FAILED_VERSION_DOWNGRADE;
        }
        if ("INSTALL_FAILED_DEXOPT".equals(failureMessage)) {
            return FailureCode.INSTALL_FAILED_DEXOPT;
        }
        if ("INSTALL_FAILED_OLDER_SDK".equals(failureMessage)) {
            return FailureCode.INSTALL_FAILED_OLDER_SDK;
        }
        return FailureCode.UNTYPED_ERROR;
    }

    public static enum FailureCode {
        NO_ERROR,
        DEVICE_NOT_RESPONDING,
        INCONSISTENT_CERTIFICATES,
        INSTALL_FAILED_VERSION_DOWNGRADE,
        INSTALL_FAILED_DEXOPT,
        NO_CERTIFICATE,
        INSTALL_FAILED_OLDER_SDK,
        UNTYPED_ERROR;

    }
}

