/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;

public class DeviceStateCache<T>
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Table<String, String, T> myCache = HashBasedTable.create();

    public DeviceStateCache(Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public T get(IDevice device, String pkgName) {
        return (T)this.myCache.get((Object)device.getSerialNumber(), (Object)pkgName);
    }

    public T put(IDevice device, String pkgName, T data) {
        return (T)this.myCache.put((Object)device.getSerialNumber(), (Object)pkgName, data);
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        this.myCache.row((Object)device.getSerialNumber()).clear();
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }
}

