/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserListener;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class DeviceChooserDialog
extends DialogWrapper {
    private final DeviceChooser myDeviceChooser;

    public DeviceChooserDialog(AndroidFacet facet, IAndroidTarget projectTarget, boolean multipleSelection, String[] selectedSerials, Predicate<IDevice> filter) {
        super(facet.getModule().getProject(), true);
        this.setTitle(AndroidBundle.message("choose.device.dialog.title", new Object[0]));
        this.getOKAction().setEnabled(false);
        this.myDeviceChooser = new DeviceChooser(multipleSelection, this.getOKAction(), facet, projectTarget, filter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myDeviceChooser);
        this.myDeviceChooser.addListener(new DeviceChooserListener(){

            @Override
            public void selectedDevicesChanged() {
                DeviceChooserDialog.this.updateOkButton();
            }
        });
        this.init();
        this.myDeviceChooser.init(selectedSerials);
    }

    private void updateOkButton() {
        IDevice[] devices = this.getSelectedDevices();
        boolean enabled = devices.length > 0;
        for (IDevice device : devices) {
            if (device.isOnline()) continue;
            enabled = false;
        }
        this.getOKAction().setEnabled(enabled);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeviceChooser.getPreferredFocusComponent();
    }

    protected void doOKAction() {
        this.myDeviceChooser.finish();
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidDeviceChooserDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myDeviceChooser.getPanel();
    }

    public IDevice[] getSelectedDevices() {
        return this.myDeviceChooser.getSelectedDevices();
    }
}

