/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.AndroidSessionManager;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule> {
    private static final Logger LOG = Logger.getInstance(AndroidRunConfigurationBase.class);
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    public static final Key<DeviceTarget> DEVICE_TARGET_KEY = Key.create((String)"android.device.target");
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    public String PREFERRED_AVD = "";
    private final List<DeployTarget> myDeployTargets = DeployTarget.getDeployTargets();
    private final boolean myAndroidTests;
    private final Map<String, DeployTargetState> myDeployTargetStates;
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = true;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myAndroidTests = androidTests;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTarget target : this.myDeployTargets) {
            builder.put((Object)target.getId(), target.createState());
        }
        this.myDeployTargetStates = builder.build();
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate();
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        if (topError.isFatal()) {
            throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
        }
        throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
    }

    private List<ValidationError> validate() {
        Pair<Boolean, String> result;
        AndroidFacet facet;
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (Projects.requiredAndroidModelMissing(project)) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        if (facet.isLibraryProject() && !((Boolean)(result = this.supportsRunningLibraryProjects(facet)).getFirst()).booleanValue()) {
            errors.add(ValidationError.fatal((String)result.getSecond()));
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (facet.getManifest() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getCurrentDeployTargetState().validate(facet));
        errors.addAll(this.getApkProvider(facet).validate());
        errors.addAll(this.checkConfiguration(facet));
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(AndroidFacet var1);

    protected abstract List<ValidationError> checkConfiguration(AndroidFacet var1);

    protected LaunchOptions.Builder getLaunchOptions() {
        return LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    public TargetSelectionMode getTargetSelectionMode() {
        try {
            return TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return TargetSelectionMode.EMULATOR;
        }
    }

    public List<DeployTarget> getApplicableDeployTargets() {
        ArrayList targets = Lists.newArrayList();
        for (DeployTarget target : this.myDeployTargets) {
            if (!target.isApplicable(this.myAndroidTests)) continue;
            targets.add(target);
        }
        return targets;
    }

    public DeployTarget getCurrentDeployTarget() {
        DeployTarget target = this.getDeployTarget(this.TARGET_SELECTION_MODE);
        if (target == null) {
            target = this.getDeployTarget(TargetSelectionMode.SHOW_DIALOG.name());
        }
        assert (target != null);
        return target;
    }

    private DeployTarget getDeployTarget(String id) {
        for (DeployTarget target : this.myDeployTargets) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        return null;
    }

    private DeployTargetState getCurrentDeployTargetState() {
        DeployTarget currentTarget = this.getCurrentDeployTarget();
        return this.myDeployTargetStates.get(currentTarget.getId());
    }

    public DeployTargetState getDeployTargetState(DeployTarget target) {
        return this.myDeployTargetStates.get(target.getId());
    }

    public void setTargetSelectionMode(TargetSelectionMode mode) {
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(DeployTarget target) {
        this.TARGET_SELECTION_MODE = target.getId();
    }

    public RunProfileState getState(Executor executor, ExecutionEnvironment env) throws ExecutionException {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        Project project = env.getProject();
        boolean debug = false;
        if (executor instanceof DefaultDebugExecutor) {
            if (!AndroidSdkUtils.activateDdmsIfNecessary(facet.getModule().getProject())) {
                throw new ExecutionException("Unable to obtain debug bridge. Please check if there is a different tool using adb that is active.");
            }
            debug = true;
        }
        if (AndroidSdkUtils.getDebugBridge(this.getProject()) == null) {
            throw new ExecutionException("Unable to obtain debug bridge");
        }
        DeployTarget currentTarget = this.getCurrentDeployTarget();
        DeployTargetState deployTargetState = this.getCurrentDeployTargetState();
        ProcessHandlerConsolePrinter printer = new ProcessHandlerConsolePrinter(null);
        if (currentTarget.requiresRuntimePrompt(deployTargetState) && !currentTarget.showPrompt(executor, env, facet, this.getDeviceCount(debug), this.myAndroidTests, this.myDeployTargetStates, this.getUniqueID(), printer)) {
            return null;
        }
        if (currentTarget.hasCustomRunProfileState(executor)) {
            return currentTarget.getRunProfileState(executor, env, deployTargetState);
        }
        DeviceTarget deviceTarget = this.getOldSessionTarget(project, executor);
        if (deviceTarget == null && (deviceTarget = currentTarget.getTarget(deployTargetState, facet, this.getDeviceCount(debug), debug, this.getUniqueID(), printer)) == null) {
            return null;
        }
        env.putCopyableUserData(DEVICE_TARGET_KEY, (Object)deviceTarget);
        if (deviceTarget.getDeviceFutures().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        LaunchOptions launchOptions = this.getLaunchOptions().setDebug(debug).build();
        return new AndroidRunningState(env, facet, this.getApkProvider(facet), deviceTarget, printer, this.getApplicationLauncher(facet), launchOptions, this);
    }

    private DeviceTarget getOldSessionTarget(Project project, Executor executor) {
        Collection<IDevice> oldDevices;
        Collection<IDevice> online;
        AndroidSessionInfo sessionInfo = AndroidSessionManager.findOldSession(project, executor, this);
        if (sessionInfo != null && sessionInfo.isEmbeddable() && !(online = DeviceSelectionUtils.getOnlineDevices(oldDevices = sessionInfo.getState().getDevices())).isEmpty()) {
            return DeviceTarget.forDevices(online);
        }
        return null;
    }

    protected abstract ApkProvider getApkProvider(AndroidFacet var1);

    protected abstract ConsoleView attachConsole(AndroidRunningState var1, Executor var2) throws ExecutionException;

    protected abstract AndroidApplicationLauncher getApplicationLauncher(AndroidFacet var1);

    public final DeviceCount getDeviceCount(boolean debug) {
        return DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
    }

    protected abstract boolean supportMultipleDevices();

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }

    public boolean usesSimpleLauncher() {
        return true;
    }
}

