/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.execution.process.ProcessOutputTypes;
import java.io.IOException;

public class AndroidDeepLinkLauncher
extends AndroidApplicationLauncher {
    private final String APP_INDEXING_LOG_COMMEND = "setprop log.tag.AppIndexApi VERBOSE";
    private final String myDeepLink;
    private final String myExtraFlags;

    public AndroidDeepLinkLauncher(String deepLink, String extraFlags) {
        this.myDeepLink = deepLink;
        this.myExtraFlags = extraFlags;
    }

    @Override
    public AndroidApplicationLauncher.LaunchResult launch(AndroidRunningState state, IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        if (state.isStopped()) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        state.getProcessHandler().notifyTextAvailable("Launching application: " + this.myDeepLink + ".\n", ProcessOutputTypes.STDOUT);
        UsageTracker.getInstance().trackEvent("appIndexing", "deepLinkLaunched", null, null);
        AndroidApplicationLauncher.LaunchResult result = this.executeCommand("setprop log.tag.AppIndexApi VERBOSE", state, device);
        if (result == AndroidApplicationLauncher.LaunchResult.STOP) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        String launchDeepLinkCommand = AndroidDeepLinkLauncher.getLaunchDeepLinkCommand(this.myDeepLink, state.getPackageName(), this.getDebugFlags(state), this.myExtraFlags);
        return this.executeCommand(launchDeepLinkCommand, state, device);
    }

    static String getLaunchDeepLinkCommand(String deepLink, String packageId, String debugFlags, String extraFlags) {
        return "am start " + debugFlags + " " + "-a android.intent.action.VIEW " + "-c android.intent.category.BROWSABLE " + "-d " + deepLink + (packageId == null ? "" : " " + packageId) + (extraFlags.isEmpty() ? "" : " " + extraFlags);
    }
}

