/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidExecutionState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.AndroidRunningStateListener;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.AndroidSessionManager;
import com.android.tools.idea.run.DebugLauncher;
import com.android.tools.idea.run.LaunchUtils;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.DefaultDebugProcessHandler;

public class AndroidDebugRunner
extends DefaultProgramRunner {
    public static final Key<AndroidSessionInfo> ANDROID_SESSION_INFO = new Key("ANDROID_SESSION_INFO");
    private static final Object myDebugLock = new Object();
    public static final String ANDROID_LOGCAT_CONTENT_ID = "Android Logcat";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidDebugRunner");

    protected RunContentDescriptor doExecute(RunProfileState state, final ExecutionEnvironment environment) throws ExecutionException {
        if (!(state instanceof AndroidRunningState)) {
            return this.doExecSimple(state, environment);
        }
        AndroidRunningState runningState = (AndroidRunningState)state;
        final RunContentDescriptor[] descriptor = new RunContentDescriptor[]{null};
        runningState.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (descriptor[0] != null) {
                            LaunchUtils.showNotification(environment.getProject(), environment.getExecutor(), descriptor[0], "Error", NotificationType.ERROR);
                        }
                    }
                });
            }

            @Override
            public void executionStarted(IDevice device) {
                Executor executor = environment.getExecutor();
                if (executor instanceof DefaultRunExecutor) {
                    LaunchUtils.showNotification(environment.getProject(), executor, descriptor[0], "Launched on " + device.getName(), NotificationType.INFORMATION);
                }
            }
        });
        descriptor[0] = this.doExec(runningState, environment);
        return descriptor[0];
    }

    private RunContentDescriptor doExecSimple(RunProfileState state, ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor descriptor = super.doExecute(state, environment);
        if (descriptor != null) {
            boolean showRunContent = environment.getRunProfile() instanceof AndroidTestRunConfiguration;
            descriptor.setActivateToolWindowWhenAdded(showRunContent);
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunContentDescriptor doExec(AndroidRunningState state, ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor descriptor;
        if (!(environment.getExecutor() instanceof DefaultDebugExecutor)) {
            return this.doExecSimple(state, environment);
        }
        Object object = myDebugLock;
        synchronized (object) {
            MyDebugLauncher launcher = new MyDebugLauncher(state, environment);
            state.setDebugLauncher(launcher);
            descriptor = AndroidDebugRunner.embedToExistingSession(environment.getProject(), environment.getExecutor(), state);
            if (descriptor != null) {
                launcher.setRunDescriptor(descriptor);
                return null;
            }
            descriptor = super.doExecute((RunProfileState)state, environment);
            if (descriptor == null) {
                return null;
            }
            launcher.setRunDescriptor(descriptor);
        }
        ProcessHandler handler = state.getProcessHandler();
        handler.putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(handler, descriptor, state, environment.getExecutor().getId()));
        descriptor.setActivateToolWindowWhenAdded(false);
        return descriptor;
    }

    protected static RunContentDescriptor embedToExistingSession(final Project project, final Executor executor, final AndroidRunningState state) {
        ProcessHandler newProcessHandler;
        AndroidSessionInfo oldSessionInfo = AndroidSessionManager.findOldSession(project, executor, state.getConfiguration());
        if (oldSessionInfo == null || !oldSessionInfo.isEmbeddable()) {
            return null;
        }
        AndroidExecutionState oldState = oldSessionInfo.getState();
        ConsoleView oldConsole = oldState.getConsoleView();
        if (oldState.getDevices() == null || !((Object)oldState.getDevices()).equals(state.getDevices())) {
            return null;
        }
        oldSessionInfo.getProcessHandler().detachProcess();
        state.setConsole(oldConsole);
        final RunContentDescriptor oldDescriptor = oldSessionInfo.getDescriptor();
        if (oldDescriptor.getProcessHandler() instanceof RemoteDebugProcessHandler) {
            newProcessHandler = oldDescriptor.getProcessHandler();
            newProcessHandler.destroyProcess();
        } else {
            newProcessHandler = new DefaultDebugProcessHandler();
        }
        oldDescriptor.setProcessHandler(newProcessHandler);
        state.setProcessHandler(newProcessHandler);
        oldConsole.attachToProcess(newProcessHandler);
        AndroidProcessText.attach(newProcessHandler);
        newProcessHandler.notifyTextAvailable("The session was restarted\n", ProcessOutputTypes.STDOUT);
        state.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                LaunchUtils.showNotification(project, executor, oldDescriptor, "Error", NotificationType.ERROR);
            }

            @Override
            public void executionStarted(IDevice device) {
                if (executor instanceof DefaultRunExecutor) {
                    LaunchUtils.showNotification(project, executor, oldDescriptor, "Running", NotificationType.INFORMATION);
                }
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                state.start();
            }
        });
        return oldDescriptor;
    }

    public String getRunnerId() {
        return "AndroidDebugRunner";
    }

    public boolean canRun(String executorId, RunProfile profile) {
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && !DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        if (!(profile instanceof AndroidRunConfigurationBase)) {
            return false;
        }
        return ((AndroidRunConfigurationBase)profile).usesSimpleLauncher();
    }

    private class MyDebugLauncher
    implements DebugLauncher {
        private final Project myProject;
        private final Executor myExecutor;
        private final AndroidRunningState myRunningState;
        private final ExecutionEnvironment myEnvironment;
        private RunContentDescriptor myRunDescriptor;

        public MyDebugLauncher(AndroidRunningState state, ExecutionEnvironment environment) {
            this.myProject = environment.getProject();
            this.myRunningState = state;
            this.myEnvironment = environment;
            this.myExecutor = environment.getExecutor();
        }

        public void setRunDescriptor(RunContentDescriptor runDescriptor) {
            this.myRunDescriptor = runDescriptor;
        }

        @Override
        public void launchDebug(final Client client) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProcessHandler newProcessHandler;
                    IDevice device = client.getDevice();
                    String debugPort = Integer.toString(client.getDebuggerListenPort());
                    RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
                    AndroidDebugState debugState = new AndroidDebugState(MyDebugLauncher.this.myProject, connection, MyDebugLauncher.this.myRunningState, device);
                    RunContentDescriptor debugDescriptor = null;
                    ProcessHandler processHandler = MyDebugLauncher.this.myRunningState.getProcessHandler();
                    processHandler.detachProcess();
                    try {
                        Object object = myDebugLock;
                        synchronized (object) {
                            assert (MyDebugLauncher.this.myRunDescriptor != null);
                            ExecutionEnvironment env = new ExecutionEnvironmentBuilder(MyDebugLauncher.this.myEnvironment).executor(MyDebugLauncher.this.myExecutor).runner((ProgramRunner)AndroidDebugRunner.this).contentToReuse(MyDebugLauncher.this.myRunDescriptor).build();
                            debugDescriptor = DebuggerPanelsManager.getInstance((Project)MyDebugLauncher.this.myProject).attachVirtualMachine(env, (RunProfileState)debugState, debugState.getRemoteConnection(), false);
                        }
                    }
                    catch (ExecutionException e) {
                        processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
                    }
                    ProcessHandler processHandler2 = newProcessHandler = debugDescriptor != null ? debugDescriptor.getProcessHandler() : null;
                    if (debugDescriptor == null || newProcessHandler == null) {
                        LOG.info("cannot start debugging");
                        return;
                    }
                    AndroidProcessText.attach(newProcessHandler);
                    AndroidProcessText oldText = AndroidProcessText.get(processHandler);
                    if (oldText != null) {
                        oldText.printTo(newProcessHandler);
                    }
                    ProcessHandler handler = MyDebugLauncher.this.myRunningState.getProcessHandler();
                    handler.putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(handler, debugDescriptor, debugState, MyDebugLauncher.this.myExecutor.getId()));
                    debugDescriptor.setActivateToolWindowWhenAdded(false);
                }
            });
        }
    }
}

