/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;

public class AndroidActivityAliasCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        Set<String> aliases;
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        Editor editor = parameters.getEditor();
        LaunchOptionConfigurableContext context = (LaunchOptionConfigurableContext)editor.getUserData(LaunchOptionConfigurableContext.KEY);
        if (context == null) {
            return;
        }
        Module module = context.getModule();
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        String prefix = parameters.getEditor().getDocument().getText().substring(0, parameters.getOffset());
        result = result.withPrefixMatcher(prefix);
        PsiClass activityClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
        if (activityClass != null) {
            final CompletionResultSet finalResult = result;
            ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)module.getModuleWithDependenciesScope(), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    String qName;
                    PsiModifierList modifierList = psiClass.getModifierList();
                    if (modifierList != null && modifierList.hasModifierProperty("public") && !modifierList.hasModifierProperty("abstract") && (qName = psiClass.getQualifiedName()) != null && qName.length() > 0) {
                        finalResult.addElement((LookupElement)JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)qName));
                    }
                    return true;
                }
            });
        }
        if ((aliases = AndroidActivityAliasCompletionContributor.collectActivityAliases(facet)).size() > 0) {
            for (String alias : aliases) {
                LookupElementBuilder element = LookupElementBuilder.create((String)alias);
                String shortName = StringUtilRt.getShortName((String)alias);
                if (!shortName.equals(alias)) {
                    element = element.withLookupString(shortName);
                }
                result.addElement((LookupElement)element);
            }
        }
        result.stopHere();
    }

    private static Set<String> collectActivityAliases(AndroidFacet facet) {
        HashSet result = new HashSet();
        AndroidActivityAliasCompletionContributor.doCollectActivityAliases(facet, (Set<String>)result);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            AndroidActivityAliasCompletionContributor.doCollectActivityAliases(depFacet, (Set<String>)result);
        }
        return result;
    }

    private static void doCollectActivityAliases(AndroidFacet facet, Set<String> result) {
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        String aPackage = manifest.getPackage().getStringValue();
        Application application = manifest.getApplication();
        if (application == null) {
            return;
        }
        for (ActivityAlias activityAlias : application.getActivityAliass()) {
            String alias = activityAlias.getName().getStringValue();
            if (alias == null || alias.length() <= 0) continue;
            if (!alias.startsWith(".")) {
                if (alias.indexOf(46) > 0) {
                    result.add(alias);
                }
                alias = "." + alias;
            }
            if (aPackage == null || aPackage.length() <= 0 || StringUtil.commonPrefixLength((CharSequence)aPackage, (CharSequence)alias) != 0) continue;
            result.add(aPackage + alias);
        }
    }
}

