/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ImageUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class ShadowPainter {
    public static final int SHADOW_SIZE = 20;
    public static final int SMALL_SHADOW_SIZE = 10;
    private static final Image ShadowBottom = ImageUtils.loadIcon("/icons/shadow-b.png");
    private static final Image ShadowBottomLeft = ImageUtils.loadIcon("/icons/shadow-bl.png");
    private static final Image ShadowBottomRight = ImageUtils.loadIcon("/icons/shadow-br.png");
    private static final Image ShadowRight = ImageUtils.loadIcon("/icons/shadow-r.png");
    private static final Image ShadowTopRight = ImageUtils.loadIcon("/icons/shadow-tr.png");
    private static final Image Shadow2Bottom = ImageUtils.loadIcon("/icons/shadow2-b.png");
    private static final Image Shadow2BottomLeft = ImageUtils.loadIcon("/icons/shadow2-bl.png");
    private static final Image Shadow2BottomRight = ImageUtils.loadIcon("/icons/shadow2-br.png");
    private static final Image Shadow2Right = ImageUtils.loadIcon("/icons/shadow2-r.png");
    private static final Image Shadow2TopRight = ImageUtils.loadIcon("/icons/shadow2-tr.png");

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize) {
        return ShadowPainter.createDropShadow(source, shadowSize /= 2, 0.7f, 0);
    }

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize, float shadowOpacity, int shadowRgb) {
        int a;
        int aSum;
        int width = source.getWidth();
        int height = source.getHeight();
        boolean isRetina = ImageUtils.isRetinaImage(source);
        if (isRetina && UIUtil.isAppleRetina()) {
            return source;
        }
        BufferedImage image = isRetina ? ImageUtils.createDipImage(width + 20, height + 20, 2) : new BufferedImage(width + 20, height + 20, 2);
        Graphics2D g2 = image.createGraphics();
        UIUtil.drawImage((Graphics)g2, (Image)source, (int)shadowSize, (int)shadowSize, null);
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        shadowRgb &= 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = shadowOpacity / (float)shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        UIUtil.drawImage((Graphics)g2, (BufferedImage)source, null, (int)0, (int)0);
        g2.dispose();
        return image;
    }

    public static BufferedImage createRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = ImageUtils.isRetinaImage(source) ? ImageUtils.createDipImage(width + 20, height + 20, type) : new BufferedImage(width + 20, height + 20, type);
        Graphics g = image.getGraphics();
        UIUtil.drawImage((Graphics)g, (Image)source, (int)0, (int)0, null);
        ShadowPainter.drawRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createSmallRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = ImageUtils.isRetinaImage(source) ? ImageUtils.createDipImage(width + 10, height + 10, type) : new BufferedImage(width + 10, height + 10, type);
        Graphics g = image.getGraphics();
        UIUtil.drawImage((Graphics)g, (Image)source, (int)0, (int)0, null);
        ShadowPainter.drawSmallRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ShadowPainter.drawRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSmallRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ShadowPainter.drawSmallRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    public static void drawRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        assert (ShadowBottomLeft != null);
        assert (ShadowBottomRight.getWidth(null) == 20);
        assert (ShadowBottomRight.getHeight(null) == 20);
        int blWidth = ShadowBottomLeft.getWidth(null);
        int trHeight = ShadowTopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        UIUtil.drawImage((Graphics)gc, (Image)ShadowBottomLeft, (int)x, (int)(y + height), null);
        UIUtil.drawImage((Graphics)gc, (Image)ShadowBottomRight, (int)(x + width), (int)(y + height), null);
        UIUtil.drawImage((Graphics)gc, (Image)ShadowTopRight, (int)(x + width), (int)y, null);
        ImageUtils.drawDipImage(gc, ShadowBottom, x + ShadowBottomLeft.getWidth(null), y + height, x + width, y + height + ShadowBottom.getHeight(null), 0, 0, ShadowBottom.getWidth(null), ShadowBottom.getHeight(null), null);
        ImageUtils.drawDipImage(gc, ShadowRight, x + width, y + ShadowTopRight.getHeight(null), x + width + ShadowRight.getWidth(null), y + height, 0, 0, ShadowRight.getWidth(null), ShadowRight.getHeight(null), null);
    }

    public static void drawSmallRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        assert (Shadow2BottomLeft != null);
        assert (Shadow2TopRight != null);
        assert (Shadow2BottomRight.getWidth(null) == 10);
        assert (Shadow2BottomRight.getHeight(null) == 10);
        int blWidth = Shadow2BottomLeft.getWidth(null);
        int trHeight = Shadow2TopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        UIUtil.drawImage((Graphics)gc, (Image)Shadow2BottomLeft, (int)x, (int)(y + height), null);
        UIUtil.drawImage((Graphics)gc, (Image)Shadow2BottomRight, (int)(x + width), (int)(y + height), null);
        UIUtil.drawImage((Graphics)gc, (Image)Shadow2TopRight, (int)(x + width), (int)y, null);
        ImageUtils.drawDipImage(gc, Shadow2Bottom, x + Shadow2BottomLeft.getWidth(null), y + height, x + width, y + height + Shadow2Bottom.getHeight(null), 0, 0, Shadow2Bottom.getWidth(null), Shadow2Bottom.getHeight(null), null);
        ImageUtils.drawDipImage(gc, Shadow2Right, x + width, y + Shadow2TopRight.getHeight(null), x + width + Shadow2Right.getWidth(null), y + height, 0, 0, Shadow2Right.getWidth(null), Shadow2Right.getHeight(null), null);
    }
}

