/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;

public class SetAttributeFix
extends WriteCommandAction<Void> {
    private final XmlTag myTag;
    private final String myNamespace;
    private final String myAttribute;
    private final String myValue;

    public SetAttributeFix(Project project, XmlTag tag, String attribute, String namespace, String value) {
        super(project, String.format("Set %1$s Attribute", StringUtil.capitalize((String)attribute)), new PsiFile[]{tag.getContainingFile()});
        this.myTag = tag;
        this.myNamespace = namespace;
        this.myAttribute = attribute;
        this.myValue = value;
    }

    protected void run(Result<Void> result) throws Throwable {
        if (this.myNamespace != null && this.myValue != null) {
            SuppressLintIntentionAction.ensureNamespaceImported(this.getProject(), (XmlFile)this.myTag.getContainingFile(), this.myNamespace);
        }
        this.myTag.setAttribute(this.myAttribute, this.myNamespace, this.myValue);
    }
}

