/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.AssetRepositoryImpl;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.collect.Maps;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.w3c.dom.Element;
import org.xmlpull.v1.XmlPullParserException;

public class RenderTask
implements IImageFactory {
    private final RenderService myRenderService;
    private XmlFile myPsiFile;
    private final RenderLogger myLogger;
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    private final AndroidVersion myMinSdkVersion;
    private final AndroidVersion myTargetSdkVersion;
    private final LayoutLibrary myLayoutLib;
    private final HardwareConfigHelper myHardwareConfigHelper;
    private IncludeReference myIncludedWithin;
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    private Integer myOverrideBgColor;
    private boolean myShowDecorations = true;
    private final Configuration myConfiguration;
    private final AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    private Set<XmlTag> myExpandNodes;
    private RenderContext myRenderContext;
    private final Locale myLocale;
    private final Object myCredential;
    private ResourceFolderType myFolderType;
    private boolean myProvideCookiesForIncludedViews = false;

    RenderTask(RenderService renderService, Configuration configuration, RenderLogger logger, LayoutLibrary layoutLib, Device device, Object credential) {
        this.myRenderService = renderService;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myConfiguration = configuration;
        AndroidFacet facet = renderService.getFacet();
        Module module = facet.getModule();
        this.myAssetRepository = new AssetRepositoryImpl(facet);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        this.myHardwareConfigHelper.setOrientation(configuration.getFullConfig().getScreenOrientationQualifier().getValue());
        this.myLayoutLib = layoutLib;
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module, facet, this.myLogger, this.myCredential, actionBarHandler);
        this.myLayoutlibCallback.loadAndParseRClass();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        this.myMinSdkVersion = moduleInfo.getMinSdkVersion();
        this.myTargetSdkVersion = moduleInfo.getTargetSdkVersion();
        this.myLocale = configuration.getLocale();
    }

    public void setPsiFile(PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            throw new IllegalArgumentException("Can only render XML files: " + psiFile.getClass().getName());
        }
        this.myPsiFile = (XmlFile)psiFile;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                RenderTask.this.myFolderType = ResourceHelper.getFolderType((PsiFile)RenderTask.this.myPsiFile);
            }
        });
    }

    public AndroidPlatform getPlatform() {
        return this.myRenderService.getPlatform();
    }

    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    public ResourceFolderType getFolderType() {
        return this.myFolderType;
    }

    public void setFolderType(ResourceFolderType folderType) {
        this.myFolderType = folderType;
    }

    public Module getModule() {
        return this.myRenderService.getModule();
    }

    public RenderLogger getLogger() {
        return this.myLogger;
    }

    public Set<XmlTag> getExpandNodes() {
        return this.myExpandNodes;
    }

    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public void dispose() {
        this.myLayoutlibCallback.setLogger(null);
        this.myLayoutlibCallback.setResourceResolver(null);
    }

    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    public RenderTask setRenderingMode(SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    public SessionParams.RenderingMode getRenderingMode() {
        return this.myRenderingMode;
    }

    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    public RenderTask setOverrideBgColor(Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        return this;
    }

    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    public RenderContext getRenderContext() {
        return this.myRenderContext;
    }

    public RenderTask setRenderContext(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        return this;
    }

    public RenderTask setNodesToExpand(Set<XmlTag> nodesToExpand) {
        this.myExpandNodes = nodesToExpand;
        return this;
    }

    public RenderTask setIncludedWithin(IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
        return this;
    }

    public IncludeReference getIncludedWithin() {
        return this.myIncludedWithin != null ? this.myIncludedWithin : IncludeReference.NONE;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    public void setProvideCookiesForIncludedViews(boolean provideCookiesForIncludedViews) {
        this.myProvideCookiesForIncludedViews = provideCookiesForIncludedViews;
    }

    private RenderResult createRenderSession(IImageFactory factory) {
        IAndroidTarget target;
        if (this.myPsiFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParserFactory.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        ILayoutPullParser includingParser = this.getIncludingLayoutParser(resolver, modelParser);
        if (includingParser != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = this.myConfiguration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        Module module = this.myRenderService.getModule();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        final SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidPsiUtils.getRootTagName((PsiFile)this.myPsiFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setExtendedViewInfoMode(true);
        ManifestInfo manifestInfo = ManifestInfo.get(module);
        LayoutDirectionQualifier qualifier = this.myConfiguration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception e) {
            // empty catch block
        }
        Device device = this.myConfiguration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                params.setAppLabel(manifestInfo.getApplicationLabel());
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = this.myConfiguration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    ManifestInfo.ActivityAttributes attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            params.setAppLabel(attributes.getLabel());
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            RenderResult result = (RenderResult)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public RenderResult compute() {
                    Module module = RenderTask.this.myRenderService.getModule();
                    RenderSecurityManager securityManager = RenderSecurityManagerFactory.create(module, RenderTask.this.getPlatform());
                    securityManager.setActive(true, RenderTask.this.myCredential);
                    try {
                        int retries = 0;
                        RenderSession session = null;
                        while (retries < 10) {
                            session = RenderTask.this.myLayoutLib.createSession(params);
                            Result result = session.getResult();
                            if (result.getStatus() != Result.Status.ERROR_TIMEOUT) {
                                if (result.isSuccess() || !"The main Looper has already been prepared.".equals(result.getErrorMessage())) break;
                                ++retries;
                                continue;
                            }
                            ++retries;
                        }
                        RenderResult renderResult = new RenderResult(RenderTask.this, session, (PsiFile)RenderTask.this.myPsiFile, RenderTask.this.myLogger);
                        return renderResult;
                    }
                    finally {
                        securityManager.dispose(RenderTask.this.myCredential);
                    }
                }
            });
            this.addDiagnostics(result.getSession());
            result.setIncludedWithin(this.myIncludedWithin);
            return result;
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    private ILayoutPullParser getIncludingLayoutParser(ResourceResolver resolver, ILayoutPullParser modelParser) {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (this.myIncludedWithin == null) {
            String layout = IncludeReference.getIncludingLayout(this.myPsiFile);
            Module module = this.myRenderService.getModule();
            IncludeReference includeReference = this.myIncludedWithin = layout != null ? IncludeReference.get(module, this.myPsiFile, (RenderResources)resolver) : IncludeReference.NONE;
        }
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)this.myPsiFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            try {
                String queryLayoutName = ResourceHelper.getResourceName((PsiFile)this.myPsiFile);
                this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
                Object topParser = null;
                PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myRenderService.getProject(), layoutVirtualFile);
                if (psiFile instanceof XmlFile) {
                    LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                    parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                    topParser = parser;
                }
                if (topParser == null) {
                    topParser = LayoutFilePullParser.create(this.myLayoutlibCallback, this.myIncludedWithin.getFromPath());
                }
                return topParser;
            }
            catch (IOException e) {
                this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), e);
            }
            catch (XmlPullParserException e) {
                this.myLogger.error(null, String.format("XML parsing error: %1$s", e.getMessage()), e.getDetail() != null ? e.getDetail() : e);
            }
        }
        return null;
    }

    public RenderResult render(final IImageFactory factory) {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("render shouldn't be called on RenderTask without PsiFile");
        }
        try {
            return RenderService.runRenderAction(new Callable<RenderResult>(){

                @Override
                public RenderResult call() throws Exception {
                    return RenderTask.this.createRenderSession(factory);
                }
            });
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myRenderService.getProject(), this.myLogger.getLinkManager(), e));
            return new RenderResult(this, null, (PsiFile)this.myPsiFile, this.myLogger);
        }
    }

    public RenderResult render() {
        return this.render(this);
    }

    private void addDiagnostics(RenderSession session) {
        ILayoutPullParser layoutEmbeddedParser;
        if (session == null) {
            return;
        }
        Result r = session.getResult();
        if (!this.myLogger.hasProblems() && !r.isSuccess()) {
            if (r.getException() != null || r.getErrorMessage() != null) {
                this.myLogger.error(null, r.getErrorMessage(), r.getException(), null);
            } else if (r.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + r.getStatus(), null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null);
        }
    }

    public BufferedImage renderDrawable(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return null;
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getModule();
        final DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        try {
            Object data;
            Result result = RenderService.runRenderAction(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return RenderTask.this.myLayoutLib.renderDrawable(params);
                }
            });
            if (result != null && result.isSuccess() && (data = result.getData()) instanceof BufferedImage) {
                return (BufferedImage)data;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public List<BufferedImage> renderDrawableAllStates(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return Collections.emptyList();
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getModule();
        final DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        boolean supportsMultipleStates = this.myLayoutLib.supports(15);
        if (supportsMultipleStates) {
            params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
        }
        try {
            Result result = RenderService.runRenderAction(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return RenderTask.this.myLayoutLib.renderDrawable(params);
                }
            });
            if (result != null && result.isSuccess()) {
                Object data = result.getData();
                if (supportsMultipleStates && data instanceof List) {
                    return (List)data;
                }
                if (!supportsMultipleStates && data instanceof BufferedImage) {
                    return Collections.singletonList((BufferedImage)data);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    public LayoutlibCallbackImpl getLayoutlibCallback() {
        return this.myLayoutlibCallback;
    }

    public XmlFile getPsiFile() {
        return this.myPsiFile;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    public boolean isNonRectangular() {
        return this.getFolderType() == ResourceFolderType.DRAWABLE;
    }

    public boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    public BufferedImage getImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void useDesignMode(final PsiFile file) {
        if (file == null) {
            return;
        }
        String tagName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                XmlTag root;
                if (file instanceof XmlFile && (root = ((XmlFile)file).getRootTag()) != null) {
                    return root.getName();
                }
                return null;
            }
        });
        if (tagName != null) {
            RenderPreviewMode currentMode = RenderPreviewMode.getCurrent();
            if (currentMode != RenderPreviewMode.NONE) {
                return;
            }
            if ("ScrollView".equals(tagName)) {
                this.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                this.setDecorations(false);
            } else if ("HorizontalScrollView".equals(tagName)) {
                this.setRenderingMode(SessionParams.RenderingMode.H_SCROLL);
                this.setDecorations(false);
            }
        }
    }

    public List<ViewInfo> measure(Element parent) {
        Result result;
        DomPullParser modelParser = new DomPullParser(parent);
        RenderSession session = this.measure((ILayoutPullParser)modelParser);
        if (session != null && (result = session.getResult()) != null && result.isSuccess()) {
            assert (session.getRootViews().size() == 1);
            return session.getRootViews();
        }
        return null;
    }

    public Map<XmlTag, ViewInfo> measureChildren(XmlTag parent, AttributeFilter filter) {
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter, parent, this.myLogger);
        HashMap map = Maps.newHashMap();
        RenderSession session = this.measure((ILayoutPullParser)modelParser);
        if (session != null) {
            Result result = session.getResult();
            if (result != null && result.isSuccess()) {
                assert (session.getRootViews().size() == 1);
                ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                List children = root.getChildren();
                for (ViewInfo info : children) {
                    Object cookie = info.getCookie();
                    if (!(cookie instanceof XmlTag)) continue;
                    map.put((XmlTag)cookie, info);
                }
            }
            return map;
        }
        return null;
    }

    public ViewInfo measureChild(XmlTag tag, AttributeFilter filter) {
        Map<XmlTag, ViewInfo> map;
        XmlTag parent = tag.getParentTag();
        if (parent != null && (map = this.measureChildren(parent, filter)) != null) {
            for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                if (entry.getKey() != tag) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private RenderSession measure(ILayoutPullParser parser) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getModule();
        final SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.FULL_EXPAND, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        ManifestInfo manifestInfo = ManifestInfo.get(module);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            return (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

                public RenderSession compute() {
                    int retries = 0;
                    while (retries < 10) {
                        RenderSession session = RenderTask.this.myLayoutLib.createSession(params);
                        Result result = session.getResult();
                        if (result.getStatus() != Result.Status.ERROR_TIMEOUT) {
                            if (!result.isSuccess() && "The main Looper has already been prepared.".equals(result.getErrorMessage())) {
                                ++retries;
                                continue;
                            }
                            return session;
                        }
                        ++retries;
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    public static interface AttributeFilter {
        public String getAttribute(XmlTag var1, String var2, String var3);
    }
}

