/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.tools.idea.rendering.AarResourceClassGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class RDotTxtParser {
    private static final String INT_ID = "int id ";
    private static final int INT_ID_LEN = "int id ".length();
    private static Logger ourLog;
    private static final Splitter COMMA_SPLITTER;

    RDotTxtParser() {
    }

    static Collection<String> getIdNames(final File rFile) {
        try {
            return (Collection)Files.readLines((File)rFile, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Collection<String>>(){
                Collection<String> idNames = new ArrayList<String>(32);

                public boolean processLine(String line) throws IOException {
                    if (!line.startsWith(RDotTxtParser.INT_ID)) {
                        return true;
                    }
                    int i = line.indexOf(32, INT_ID_LEN);
                    assert (i != -1) : "File not in expected format: " + rFile.getPath() + "\n" + "Expected the ids to be in the format int id <name> <number>";
                    this.idNames.add(line.substring(INT_ID_LEN, i));
                    return true;
                }

                public Collection<String> getResult() {
                    return this.idNames;
                }
            });
        }
        catch (IOException e) {
            RDotTxtParser.getLog().warn("Unable to read file: " + rFile.getPath(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static Integer[] getDeclareStyleableArray(File r, final List<AttrResourceValue> attrs, final String styleableName) {
        try {
            return (Integer[])Files.readLines((File)r, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Integer[]>(){
                private static final String INT_STYLEABLE = "int styleable ";
                private final String myArrayStart;
                private final String myEntryStart;
                private Integer[] myValuesList;
                private String[] myDeclaredAttrs;
                private int myAttrsFound;
                {
                    this.myArrayStart = "int[] styleable " + styleableName + " { ";
                    this.myEntryStart = INT_STYLEABLE + styleableName + "_";
                }

                public boolean processLine(String line) throws IOException {
                    if (line.startsWith(this.myArrayStart)) {
                        String valuesList = line.substring(this.myArrayStart.length(), line.length() - 1);
                        this.myValuesList = new Integer[StringUtil.countChars((CharSequence)valuesList, (char)',') + 1];
                        this.myDeclaredAttrs = new String[this.myValuesList.length];
                        int idx = 0;
                        for (String s : COMMA_SPLITTER.split((CharSequence)valuesList)) {
                            this.myValuesList[idx++] = Integer.decode(s);
                        }
                        return true;
                    }
                    if (line.startsWith(this.myEntryStart)) {
                        assert (this.myValuesList != null) : "Entries for a declare-styleable should be after the array declaration.";
                        int lastSpace = line.lastIndexOf(32);
                        String name = line.substring(INT_STYLEABLE.length(), lastSpace);
                        int index = Integer.parseInt(line.substring(lastSpace + 1));
                        this.myDeclaredAttrs[index] = name;
                        ++this.myAttrsFound;
                        return this.myAttrsFound != this.myDeclaredAttrs.length;
                    }
                    return true;
                }

                public Integer[] getResult() {
                    if (this.myValuesList == null) {
                        return null;
                    }
                    int index = 0;
                    for (AttrResourceValue attr : attrs) {
                        String name = AarResourceClassGenerator.getResourceName(styleableName, attr);
                        for (int i = index; i < this.myDeclaredAttrs.length; ++i) {
                            String declaredAttr = this.myDeclaredAttrs[i];
                            if (!declaredAttr.equals(name)) continue;
                            ArrayUtil.swap((Object[])this.myDeclaredAttrs, (int)i, (int)index);
                            ArrayUtil.swap((Object[])this.myValuesList, (int)i, (int)index);
                            break;
                        }
                        assert (this.myDeclaredAttrs[index].equals(name)) : name + " does not equal " + this.myDeclaredAttrs[index];
                        ++index;
                    }
                    return this.myValuesList;
                }
            });
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Logger getLog() {
        if (ourLog == null) {
            ourLog = Logger.getInstance(RDotTxtParser.class);
        }
        return ourLog;
    }

    static {
        COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    }
}

