/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.PsiResourceFile;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LocalResourceRepository
extends AbstractResourceRepository
implements Disposable,
ModificationTracker {
    protected static final Logger LOG = Logger.getInstance(LocalResourceRepository.class);
    private final String myDisplayName;
    private List<MultiResourceRepository> myParents;
    protected long myGeneration;

    protected LocalResourceRepository(String displayName) {
        super(false);
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void dispose() {
    }

    public final boolean isFramework() {
        return false;
    }

    public void addParent(MultiResourceRepository parent) {
        if (this.myParents == null) {
            this.myParents = Lists.newArrayListWithExpectedSize((int)2);
        }
        this.myParents.add(parent);
    }

    public void removeParent(MultiResourceRepository parent) {
        if (this.myParents != null) {
            this.myParents.remove((Object)parent);
        }
    }

    protected void invalidateItemCaches(ResourceType ... types) {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache(this, types);
            }
        }
    }

    protected final void merge(Set<LocalResourceRepository> visited, ResourceType type, SetMultimap<String, String> seenQualifiers, ListMultimap<String, ResourceItem> result) {
        if (visited.contains((Object)this)) {
            return;
        }
        visited.add(this);
        this.doMerge(visited, type, seenQualifiers, result);
    }

    protected void doMerge(Set<LocalResourceRepository> visited, ResourceType type, SetMultimap<String, String> seenQualifiers, ListMultimap<String, ResourceItem> result) {
        ListMultimap items = this.getMap(type, false);
        if (items == null) {
            return;
        }
        for (ResourceItem item : items.values()) {
            String name = item.getName();
            String qualifiers = item.getQualifiers();
            if (result.containsKey((Object)name) && type != ResourceType.ID && seenQualifiers.containsEntry((Object)name, (Object)qualifiers)) continue;
            result.put((Object)name, (Object)item);
            seenQualifiers.put((Object)name, (Object)qualifiers);
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    public VirtualFile getMatchingFile(VirtualFile file, ResourceType type, FolderConfiguration config) {
        List<VirtualFile> matches = this.getMatchingFiles(file, type, config);
        return matches.isEmpty() ? null : matches.get(0);
    }

    public List<VirtualFile> getMatchingFiles(VirtualFile file, ResourceType type, FolderConfiguration config) {
        List matches = super.getMatchingFiles(ResourceHelper.getResourceName(file), type, config);
        ArrayList<VirtualFile> matchesFiles = new ArrayList<VirtualFile>(matches.size());
        for (ResourceFile match : matches) {
            if (match == null) continue;
            if (match instanceof PsiResourceFile) {
                matchesFiles.add(((PsiResourceFile)match).getPsiFile().getVirtualFile());
                continue;
            }
            matchesFiles.add(LocalFileSystem.getInstance().findFileByIoFile(match.getFile()));
        }
        return matchesFiles;
    }

    @Deprecated
    public ResourceFile getMatchingFile(String name, ResourceType type, FolderConfiguration config) {
        assert (name.indexOf(46) == -1) : name;
        return super.getMatchingFile(name, type, config);
    }

    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        return null;
    }

    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        return null;
    }

    public boolean isScanPending(PsiFile psiFile) {
        return false;
    }

    public static PsiFile getItemPsiFile(Project project, ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getPsiFile();
        }
        ResourceFile source = (ResourceFile)item.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof PsiResourceFile) {
            PsiResourceFile prf = (PsiResourceFile)source;
            return prf.getPsiFile();
        }
        File file = source.getFile();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            return psiManager.findFile(virtualFile);
        }
        return null;
    }

    public static XmlTag getItemTag(Project project, ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getTag();
        }
        PsiFile psiFile = LocalResourceRepository.getItemPsiFile(project, item);
        if (psiFile instanceof XmlFile) {
            String resourceName = item.getName();
            XmlFile xmlFile = (XmlFile)psiFile;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null && rootTag.isValid()) {
                XmlTag[] subTags;
                for (XmlTag tag : subTags = rootTag.getSubTags()) {
                    if (!tag.isValid() || !resourceName.equals(tag.getAttributeValue("name"))) continue;
                    return tag;
                }
            }
            assert (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) : item.getType();
        }
        return null;
    }

    public String getViewTag(ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiResourceItem psiItem = (PsiResourceItem)item;
            XmlTag tag = psiItem.getTag();
            if (tag != null && tag.isValid()) {
                return tag.getName();
            }
            String id = item.getName();
            PsiFile file = psiItem.getPsiFile();
            if (file.isValid() && file instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && rootTag.isValid()) {
                return LocalResourceRepository.findViewTag(rootTag, id);
            }
        }
        return null;
    }

    private static String findViewTag(XmlTag tag, String target) {
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null && id.endsWith(target) && target.equals(LintUtils.stripIdPrefix((String)id))) {
            return tag.getName();
        }
        for (XmlTag sub : tag.getSubTags()) {
            String found;
            if (!sub.isValid() || (found = LocalResourceRepository.findViewTag(sub, target)) == null) continue;
            return found;
        }
        return null;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }
}

