/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.rendering.AarResourceClassRegistry;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.RDotTxtParser;
import com.android.util.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;

public class AppResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private List<FileResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private final LinkedList<FileResourceRepository> myAarLibraries = new LinkedList();
    private Set<String> myIds;
    private ResourceVisibilityLookup myResourceVisibility;
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<TypedResourceName> myName2DynamicIdMap = new TObjectIntHashMap();
    private final TIntObjectHashMap<TypedResourceName> myDynamicId2ResourceMap = new TIntObjectHashMap();
    private int myDynamicSeed = 0x7FFF0000;
    private final IntArrayWrapper myWrapper = new IntArrayWrapper(null);

    protected AppResourceRepository(AndroidFacet facet, List<? extends LocalResourceRepository> delegates, List<FileResourceRepository> libraries) {
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myFacet = facet;
        this.myLibraries = libraries;
        for (FileResourceRepository library : libraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
    }

    public static AppResourceRepository getAppResources(Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getAppResources(createIfNecessary);
        }
        return null;
    }

    public static AppResourceRepository getAppResources(AndroidFacet facet, boolean createIfNecessary) {
        return facet.getAppResources(createIfNecessary);
    }

    public static AppResourceRepository create(AndroidFacet facet) {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        List<LocalResourceRepository> delegates = AppResourceRepository.computeRepositories(facet, libraries);
        final AppResourceRepository repository = new AppResourceRepository(facet, delegates, libraries);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(Project project) {
                repository.updateRoots();
            }
        });
        Project project = facet.getModule().getProject();
        AndroidProjectBuildNotifications.subscribe(project, (Disposable)facet, new AndroidProjectBuildNotifications.AndroidProjectBuildListener(){

            @Override
            public void buildComplete(AndroidProjectBuildNotifications.BuildContext context) {
                repository.updateRoots();
            }
        });
        return repository;
    }

    private static List<LocalResourceRepository> computeRepositories(AndroidFacet facet, List<FileResourceRepository> libraries) {
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(facet, true);
        repositories.addAll(libraries);
        repositories.add(resources);
        return repositories;
    }

    private static List<FileResourceRepository> computeLibraries(AndroidFacet facet) {
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        List<File> aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets);
        if (aarDirs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : aarDirs) {
            resources.add(FileResourceRepository.get(root));
        }
        return resources;
    }

    private static List<File> findAarLibraries(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(facet);
        if (androidGradleModel != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, androidGradleModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidGradleModel dependentGradleModel = AndroidGradleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
            return AppResourceRepository.findAarLibrariesFromGradle(dependentFacets, libraries);
        }
        return AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
    }

    public static Collection<AndroidLibrary> findAarLibraries(AndroidFacet facet) {
        AndroidGradleModel androidModel;
        ArrayList libraries = Lists.newArrayList();
        if (facet.requiresAndroidModel() && (androidModel = AndroidGradleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidGradleModel dependentGradleModel = AndroidGradleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        return libraries;
    }

    private static List<File> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashSet dirs = Sets.newHashSet();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        ArrayList<File> sorted = new ArrayList<File>(dirs);
        Collections.sort(sorted);
        return sorted;
    }

    private static List<File> findAarLibrariesFromGradle(List<AndroidFacet> dependentFacets, List<AndroidLibrary> libraries) {
        HashSet files = Sets.newHashSetWithExpectedSize((int)dependentFacets.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        for (AndroidLibrary library : libraries) {
            File resFolder;
            String libraryName = null;
            String projectName = library.getProject();
            if (projectName != null && !projectName.isEmpty()) {
                libraryName = projectName.substring(projectName.lastIndexOf(58) + 1);
                moduleNames.add(libraryName);
                continue;
            }
            File folder = library.getFolder();
            String name = folder.getName();
            if (name.endsWith(".aar")) {
                libraryName = name.substring(0, name.length() - ".aar".length());
            } else if (folder.getPath().contains("exploded-aar")) {
                libraryName = folder.getParentFile().getName();
            }
            if (libraryName == null || moduleNames.contains(libraryName) || !(resFolder = library.getResFolder()).exists()) continue;
            files.add(resFolder);
            moduleNames.add(libraryName);
        }
        ArrayList dirs = Lists.newArrayList();
        for (File resFolder : files) {
            dirs.add(resFolder);
        }
        Collections.sort(dirs);
        return dirs;
    }

    private static void addGradleLibraries(List<AndroidLibrary> list, AndroidGradleModel androidGradleModel) {
        Collection libraries = androidGradleModel.getMainArtifact().getDependencies().getLibraries();
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : libraries) {
            AppResourceRepository.addGradleLibrary(list, library, unique);
        }
    }

    private static void addGradleLibrary(List<AndroidLibrary> list, AndroidLibrary library, Set<File> unique) {
        File folder = library.getFolder();
        if (!unique.add(folder)) {
            return;
        }
        list.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AppResourceRepository.addGradleLibrary(list, dependency, unique);
        }
    }

    public List<FileResourceRepository> getLibraries() {
        return this.myLibraries;
    }

    Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (FileResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (FileResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds());
            }
            this.myIds.addAll(this.getItemsOfType(ResourceType.ID));
        }
        return this.myIds;
    }

    void updateRoots() {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    void updateRoots(List<LocalResourceRepository> resources, List<FileResourceRepository> libraries) {
        this.myResourceVisibility = null;
        this.myResourceVisibilityProvider = null;
        if (((Object)resources).equals(this.myChildren)) {
            return;
        }
        this.myResourceVisibility = null;
        this.myLibraries = libraries;
        this.myAarLibraries.clear();
        for (FileResourceRepository library : this.myLibraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
        this.setChildren(resources);
        this.resetDynamicIds(true);
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    static AppResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules, List<FileResourceRepository> libraries) {
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        return new AppResourceRepository(facet, modules, libraries);
    }

    public FileResourceRepository findRepositoryFor(File aarDirectory) {
        String aarPath = aarDirectory.getPath();
        assert (aarPath.endsWith(".aar") || aarPath.contains("exploded-aar")) : aarPath;
        for (FileResourceRepository r : this.myLibraries) {
            if (r instanceof FileResourceRepository) {
                FileResourceRepository repository = r;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)r)).getClass();
        }
        return null;
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || this.myFacet.getAndroidModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    public ResourceVisibilityLookup getResourceVisibility(AndroidFacet facet) {
        ResourceVisibilityLookup.Provider provider;
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel != null && (provider = this.getResourceVisibilityProvider()) != null) {
            AndroidProject androidProject = androidModel.getAndroidProject();
            Variant variant = androidModel.getSelectedVariant();
            return provider.get(androidProject, variant);
        }
        return ResourceVisibilityLookup.NONE;
    }

    public boolean isPrivate(ResourceType type, String name) {
        if (this.myResourceVisibility == null) {
            ResourceVisibilityLookup.Provider provider = this.getResourceVisibilityProvider();
            if (provider == null) {
                return false;
            }
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel == null) {
                return false;
            }
            this.myResourceVisibility = provider.get(androidModel.getAndroidProject(), androidModel.getSelectedVariant());
        }
        return this.myResourceVisibility.isPrivate(type, name);
    }

    public Pair<ResourceType, String> resolveResourceId(int id) {
        TypedResourceName pair;
        Pair<ResourceType, String> result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair<ResourceType, String>)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (TypedResourceName)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair.toPair();
        }
        return result;
    }

    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            return this.getDynamicId(type, name);
        }
        return map.get((Object)name);
    }

    Integer[] getDeclaredArrayValues(List<AttrResourceValue> attrs, String styleableName) {
        ListIterator iter = this.myAarLibraries.listIterator();
        while (iter.hasNext()) {
            Integer[] in;
            FileResourceRepository repo = (FileResourceRepository)((Object)iter.next());
            File resourceTextFile = repo.getResourceTextFile();
            if (resourceTextFile == null || (in = RDotTxtParser.getDeclareStyleableArray(resourceTextFile, attrs, styleableName)) == null) continue;
            iter.remove();
            this.myAarLibraries.addFirst(repo);
            return in;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TypedResourceName key = new TypedResourceName(type, name);
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)key)) {
                return this.myName2DynamicIdMap.get((Object)key);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)key, value);
            this.myDynamicId2ResourceMap.put(value, (Object)key);
            return value;
        }
    }

    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        this.resetDynamicIds(true);
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetDynamicIds(boolean clearAarResourceRegistry) {
        if (clearAarResourceRegistry) {
            AarResourceClassRegistry.get(this.myFacet.getModule().getProject()).clearCache(this);
        }
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
    }

    private static final class TypedResourceName {
        final ResourceType myType;
        final String myName;
        Pair<ResourceType, String> myPair;

        public TypedResourceName(ResourceType type, String name) {
            this.myType = type;
            this.myName = name;
        }

        public Pair<ResourceType, String> toPair() {
            if (this.myPair == null) {
                this.myPair = Pair.of((Object)this.myType, (Object)this.myName);
            }
            return this.myPair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedResourceName that = (TypedResourceName)o;
            if (this.myType != that.myType) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Type=%1$s, value=%2$s", this.myType, this.myName);
        }
    }
}

