/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.google.common.collect.Maps;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class AarResourceClassGenerator {
    private Map<ResourceType, TObjectIntHashMap<String>> myCache;
    private Map<String, List<Integer>> myStyleableCache;
    private final AppResourceRepository myAppResources;

    private AarResourceClassGenerator(AppResourceRepository appResources) {
        this.myAppResources = appResources;
    }

    public static AarResourceClassGenerator create(AppResourceRepository appResources) {
        return new AarResourceClassGenerator(appResources);
    }

    public byte[] generate(String fqcn) {
        String className = fqcn.replace('.', '/');
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, Type.getInternalName(Object.class), null);
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String typeName = className.substring(index + 1);
            ResourceType type = ResourceType.getEnum((String)typeName);
            if (type == null) {
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index), typeName, 25);
            if (this.myCache == null) {
                this.myCache = Maps.newHashMap();
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    TObjectIntHashMap styleableIntCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)styleableIntCache);
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, (TObjectIntHashMap<String>)styleableIntCache, className);
                } else {
                    TObjectIntHashMap<String> styleableIntCache = this.myCache.get(type);
                    assert (styleableIntCache != null);
                    AarResourceClassGenerator.generateFields(cw, styleableIntCache);
                    AarResourceClassGenerator.generateIntArrayFromCache(cw, className, this.myStyleableCache);
                }
            } else {
                TObjectIntHashMap typeCache = this.myCache.get(type);
                if (typeCache == null) {
                    typeCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)typeCache);
                    this.generateValuesForType(cw, type, (TObjectIntHashMap<String>)typeCache);
                } else {
                    AarResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            boolean styleableAdded = false;
            for (ResourceType t : this.myAppResources.getAvailableResourceTypes()) {
                if (t == ResourceType.DECLARE_STYLEABLE) {
                    t = ResourceType.STYLEABLE;
                }
                if (t == ResourceType.STYLEABLE) {
                    if (styleableAdded) continue;
                    styleableAdded = true;
                }
                cw.visitInnerClass(className + "$" + t.getName(), className, t.getName(), 25);
            }
        }
        AarResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(ClassWriter cw, ResourceType resType, TObjectIntHashMap<String> cache) {
        Collection<String> keys = resType == ResourceType.ID ? this.myAppResources.getAllIds() : this.myAppResources.getItemsOfType(resType);
        for (String key : keys) {
            int initialValue = this.myAppResources.getResourceId(resType, key);
            key = AndroidResourceUtil.getFieldNameByResourceName(key);
            AarResourceClassGenerator.generateField(cw, key, initialValue);
            cache.put((Object)key, initialValue);
        }
    }

    private void generateStyleable(ClassWriter cw, TObjectIntHashMap<String> styleableIntCache, String className) {
        Collection declaredStyleables = this.myAppResources.getItemsOfType(ResourceType.DECLARE_STYLEABLE);
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) continue;
            cw.visitField(25, styleableName, "[I", null, null);
            ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
            assert (resourceValue instanceof DeclareStyleableResourceValue);
            DeclareStyleableResourceValue dv = (DeclareStyleableResourceValue)resourceValue;
            List attributes = dv.getAllAttributes();
            int idx = 0;
            for (AttrResourceValue value : attributes) {
                Integer initialValue = idx++;
                String styleableEntryName = AarResourceClassGenerator.getResourceName(styleableName, value);
                cw.visitField(25, styleableEntryName, "I", null, (Object)initialValue);
                styleableIntCache.put((Object)styleableEntryName, initialValue.intValue());
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) continue;
            ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
            assert (resourceValue instanceof DeclareStyleableResourceValue);
            DeclareStyleableResourceValue dv = (DeclareStyleableResourceValue)resourceValue;
            List attributes = dv.getAllAttributes();
            if (attributes.isEmpty()) continue;
            Integer[] valuesArray = this.myAppResources.getDeclaredArrayValues(attributes, styleableName);
            if (valuesArray == null) {
                valuesArray = new Integer[attributes.size()];
            }
            List<Integer> values = Arrays.asList(valuesArray);
            this.myStyleableCache.put(styleableName, values);
            int idx = -1;
            for (AttrResourceValue value : attributes) {
                if (valuesArray[++idx] != null && value.isFramework()) continue;
                valuesArray[idx] = this.myAppResources.getResourceId(ResourceType.ATTR, value.getName());
            }
            AarResourceClassGenerator.generateArrayInitialization(mv, className, styleableName, values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(final ClassWriter cw, TObjectIntHashMap<String> values) {
        values.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String name, int value) {
                AarResourceClassGenerator.generateField(cw, name, value);
                return true;
            }
        });
    }

    private static void generateField(ClassWriter cw, String name, int value) {
        cw.visitField(25, name, "I", null, (Object)value).visitEnd();
    }

    private static void generateIntArrayFromCache(ClassWriter cw, String className, Map<String, List<Integer>> styleableCache) {
        for (String name : styleableCache.keySet()) {
            cw.visitField(25, name, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (Map.Entry<String, List<Integer>> entry : styleableCache.entrySet()) {
            List<Integer> values = entry.getValue();
            if (values.isEmpty()) continue;
            AarResourceClassGenerator.generateArrayInitialization(mv, className, entry.getKey(), values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateArrayInitialization(MethodVisitor mv, String className, String fieldName, List<Integer> values) {
        if (values.isEmpty()) {
            return;
        }
        mv.visitIntInsn(16, values.size());
        mv.visitIntInsn(188, 10);
        int idx = 0;
        for (Integer value : values) {
            mv.visitInsn(89);
            switch (idx) {
                case 0: {
                    mv.visitInsn(3);
                    break;
                }
                case 1: {
                    mv.visitInsn(4);
                    break;
                }
                case 2: {
                    mv.visitInsn(5);
                    break;
                }
                case 3: {
                    mv.visitInsn(6);
                    break;
                }
                case 4: {
                    mv.visitInsn(7);
                    break;
                }
                case 5: {
                    mv.visitInsn(8);
                    break;
                }
                default: {
                    mv.visitIntInsn(16, idx);
                }
            }
            mv.visitLdcInsn((Object)value);
            mv.visitInsn(79);
            ++idx;
        }
        mv.visitFieldInsn(179, className, fieldName, "[I");
    }

    private static void generateConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static String getResourceName(String styleableName, AttrResourceValue value) {
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (value.isFramework()) {
            sb.append("android_");
        }
        String v = value.getName();
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            char c = v.charAt(i);
            if (c == '.' || c == ':' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

