/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;

public class AndroidProjectBuildNotifications {
    private static final Topic<AndroidProjectBuildListener> PROJECT_BUILD_LISTENER_TOPIC = new Topic("Android Project Build", AndroidProjectBuildListener.class);
    private final Project myProject;
    private final MessageBus myMessageBus;

    public static void subscribe(Project project, AndroidProjectBuildListener listener) {
        AndroidProjectBuildNotifications.subscribe(project, (Disposable)project, listener);
    }

    public static void subscribe(Project project, Disposable disposable, AndroidProjectBuildListener listener) {
        MessageBusConnection connection = project.getMessageBus().connect(disposable);
        connection.subscribe(PROJECT_BUILD_LISTENER_TOPIC, (Object)listener);
    }

    public static AndroidProjectBuildNotifications getInstance(Project project) {
        return (AndroidProjectBuildNotifications)ServiceManager.getService((Project)project, AndroidProjectBuildNotifications.class);
    }

    public AndroidProjectBuildNotifications(Project project, MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void notifyBuildComplete(final BuildContext context) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                ((AndroidProjectBuildListener)AndroidProjectBuildNotifications.this.myMessageBus.syncPublisher(PROJECT_BUILD_LISTENER_TOPIC)).buildComplete(context);
            }
        });
    }

    public static interface BuildContext {
    }

    public static interface AndroidProjectBuildListener {
        public void buildComplete(BuildContext var1);
    }
}

