/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;

public class CaptureEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String ID = "capture-editor";

    public boolean accept(Project project, VirtualFile file) {
        CaptureType type = CaptureTypeService.getInstance().getTypeFor(file);
        return type != null && type.accept(file);
    }

    public FileEditor createEditor(Project project, VirtualFile file) {
        CaptureType type = CaptureTypeService.getInstance().getTypeFor(file);
        if (type == null) {
            throw new IllegalStateException("Type has been removed between accept and createEditor");
        }
        UsageTracker.getInstance().trackEvent("profiling", "captureOpened", type.getName(), null);
        return type.createEditor(project, file);
    }

    public void disposeEditor(FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    public FileEditorState readState(Element sourceElement, Project project, VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(FileEditorState state, Project project, Element targetElement) {
    }

    public String getEditorTypeId() {
        return ID;
    }

    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

