/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;

public class WizardUtils {
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");
    public static final int WINDOWS_PATH_LENGTH_LIMIT = 100;

    public static String computeModuleName(String appName, Project project) {
        String moduleName = appName.toLowerCase().replaceAll("[/\\\\?%*:|\"<>!;]", "");
        if (!WizardUtils.isUniqueModuleName(moduleName = moduleName.replaceAll("\\s", ""), project)) {
            int i = 2;
            while (!WizardUtils.isUniqueModuleName(moduleName + Integer.toString(i), project)) {
                ++i;
            }
            moduleName = moduleName + Integer.toString(i);
        }
        return moduleName;
    }

    public static boolean isUniqueModuleName(String moduleName, Project project) {
        if (project == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }

    public static File[] listFiles(File dir) {
        File[] files;
        if (dir != null && (files = dir.listFiles()) != null) {
            return files;
        }
        return ArrayUtil.EMPTY_FILE_ARRAY;
    }

    public static ValidationResult validateLocation(String projectLocation) {
        return WizardUtils.validateLocation(projectLocation, "project location", true);
    }

    public static ValidationResult validateLocation(String projectLocation, String fieldName, boolean checkEmpty) {
        return WizardUtils.validateLocation(projectLocation, fieldName, checkEmpty, true);
    }

    public static ValidationResult validateLocation(String projectLocation, String fieldName, boolean checkEmpty, boolean checkWriteable) {
        ValidationResult warningResult = null;
        if (projectLocation == null || projectLocation.isEmpty()) {
            return ValidationResult.error(ValidationResult.Message.NO_LOCATION_SPECIFIED, fieldName, new Object[0]);
        }
        if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
            return ValidationResult.error(ValidationResult.Message.BAD_SLASHES, fieldName, new Object[0]);
        }
        for (File testFile = new File(projectLocation); testFile != null; testFile = testFile.getParentFile()) {
            String filename = testFile.getName();
            if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                return ValidationResult.error(ValidationResult.Message.ILLEGAL_CHARACTER, fieldName, Character.valueOf(illegalChar), filename);
            }
            if (WizardConstants.INVALID_WINDOWS_FILENAMES.contains(filename.toLowerCase())) {
                return ValidationResult.error(ValidationResult.Message.ILLEGAL_FILENAME, fieldName, filename);
            }
            if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)filename)) {
                warningResult = ValidationResult.warn(ValidationResult.Message.WHITESPACE, fieldName, new Object[0]);
            }
            if (!CharMatcher.ASCII.matchesAllOf((CharSequence)filename)) {
                if (SystemInfo.isWindows) {
                    return ValidationResult.error(ValidationResult.Message.NON_ASCII_CHARS_ERROR, fieldName, new Object[0]);
                }
                warningResult = ValidationResult.warn(ValidationResult.Message.NON_ASCII_CHARS_WARNING, fieldName, new Object[0]);
            }
            if (!checkWriteable || testFile.exists() || testFile.getParentFile() == null || !testFile.getParentFile().exists() || testFile.getParentFile().canWrite()) continue;
            return ValidationResult.error(ValidationResult.Message.PATH_NOT_WRITEABLE, fieldName, testFile.getParentFile().getPath());
        }
        if (SystemInfo.isWindows && projectLocation.length() > 100) {
            return ValidationResult.error(ValidationResult.Message.PATH_TOO_LONG, fieldName, new Object[0]);
        }
        File file = new File(projectLocation);
        if (file.isFile()) {
            return ValidationResult.error(ValidationResult.Message.PROJECT_LOC_IS_FILE, fieldName, new Object[0]);
        }
        if (file.getParent() == null) {
            return ValidationResult.error(ValidationResult.Message.PROJECT_IS_FILE_SYSTEM_ROOT, fieldName, new Object[0]);
        }
        if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
            return ValidationResult.error(ValidationResult.Message.PARENT_NOT_DIR, fieldName, new Object[0]);
        }
        if (checkWriteable && file.exists() && !file.canWrite()) {
            return ValidationResult.error(ValidationResult.Message.PATH_NOT_WRITEABLE, fieldName, file.getPath());
        }
        String installLocation = PathManager.getHomePathFor(Application.class);
        if (installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false)) {
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            return ValidationResult.error(ValidationResult.Message.INSIDE_ANDROID_STUDIO, fieldName, applicationName);
        }
        if (checkEmpty && file.exists() && WizardUtils.listFiles(file).length > 0) {
            return ValidationResult.warn(ValidationResult.Message.NON_EMPTY_DIR, fieldName, new Object[0]);
        }
        return warningResult == null ? ValidationResult.OK : warningResult;
    }

    public static class ValidationResult {
        public static final ValidationResult OK = new ValidationResult(Status.OK, null, "any", new Object[0]);
        private final Status myStatus;
        private final Message myMessage;
        private final Object[] myMessageParams;

        private ValidationResult(Status status, Message message, String field, Object ... messageParams) {
            this.myStatus = status;
            this.myMessage = message;
            this.myMessageParams = ArrayUtil.prepend((Object)field, (Object[])messageParams);
        }

        public static ValidationResult warn(Message message, String field, Object ... params) {
            return new ValidationResult(Status.WARN, message, field, params);
        }

        public static ValidationResult error(Message message, String field, Object ... params) {
            return new ValidationResult(Status.ERROR, message, field, params);
        }

        Message getMessage() {
            return this.myMessage;
        }

        Object[] getMessageParams() {
            return this.myMessageParams;
        }

        public String getFormattedMessage() {
            if (this.myMessage == null) {
                throw new IllegalStateException("Null message, are you trying to get the message of an OK?");
            }
            return String.format(this.myMessage.toString(), this.myMessageParams);
        }

        public Status getStatus() {
            return this.myStatus;
        }

        public boolean isError() {
            return this.myStatus.equals((Object)Status.ERROR);
        }

        public boolean isOk() {
            return this.myStatus.equals((Object)Status.OK);
        }

        public static enum Message {
            NO_LOCATION_SPECIFIED("Please specify a %1$s"),
            BAD_SLASHES("Your %1$s contains incorrect slashes ('\\' vs '/')"),
            ILLEGAL_CHARACTER("Illegal character in %1$s path: '%2$c' in filename %3s"),
            ILLEGAL_FILENAME("Illegal filename in %1$s path: %2$s"),
            WHITESPACE("%1$s should not contain whitespace, as this can cause problems with the NDK tools."),
            NON_ASCII_CHARS_WARNING("Your %1$s contains non-ASCII characters, which can cause problems. Proceed with caution."),
            NON_ASCII_CHARS_ERROR("Your %1$s contains non-ASCII characters."),
            PATH_NOT_WRITEABLE("The path '%2$s' is not writeable. Please choose a new location."),
            PROJECT_LOC_IS_FILE("There must not already be a file at the %1$s."),
            NON_EMPTY_DIR("A non-empty directory already exists at the specified %1$s. Existing files may be overwritten. Proceed with caution."),
            PROJECT_IS_FILE_SYSTEM_ROOT("The %1$s can not be at the filesystem root"),
            IS_UNDER_ANDROID_STUDIO_ROOT("Path points to a location within Android Studio installation directory"),
            PARENT_NOT_DIR("The %1$s's parent directory must be a directory, not a plain file"),
            INSIDE_ANDROID_STUDIO("The %1$s is inside %2$s install location"),
            PATH_TOO_LONG("The %1$s is too long");

            private final String myText;

            private Message(String text) {
                this.myText = text;
            }

            public String toString() {
                return this.myText;
            }
        }

        public static enum Status {
            OK,
            WARN,
            ERROR;

        }
    }
}

