/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.npw.TemplateWizardModuleBuilder;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.BuilderBasedTemplate;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class TemplateWizardProjectTemplateFactory
extends ProjectTemplatesFactory {
    public static final ProjectTemplate[] EMPTY_PROJECT_TEMPLATES = new ProjectTemplate[0];
    private static final String IMPORT_EXISTING_PROJECT_TEMPLATE_NAME = "ImportExistingProject";

    public String[] getGroups() {
        return new String[]{"Android"};
    }

    public Icon getGroupIcon(String group) {
        return AndroidIcons.Android;
    }

    public String getParentGroup(String group) {
        return "Java";
    }

    public int getGroupWeight(String group) {
        return 60;
    }

    public ProjectTemplate[] createTemplates(String group, WizardContext context) {
        Project project = context.getProject();
        if (project != null && !Projects.requiresAndroidModel(project)) {
            return EMPTY_PROJECT_TEMPLATES;
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates("gradle-projects");
        ArrayList<AndroidProjectTemplate> tt = new ArrayList<AndroidProjectTemplate>();
        for (File template : templates) {
            TemplateMetadata metadata;
            String templateName = template.getName();
            if ("NewAndroidProject".equals(templateName) || IMPORT_EXISTING_PROJECT_TEMPLATE_NAME.equals(templateName) || project == null && !"NewAndroidModule".equals(templateName) || (metadata = manager.getTemplate(template)) == null || !metadata.isSupported()) continue;
            tt.add(new AndroidProjectTemplate(template, metadata, project));
        }
        return tt.toArray(new ProjectTemplate[tt.size()]);
    }

    private static class AndroidProjectTemplate
    extends BuilderBasedTemplate {
        private final TemplateMetadata myTemplateMetadata;

        private AndroidProjectTemplate(File templateFile, TemplateMetadata metadata, Project project) {
            super((ModuleBuilder)new TemplateWizardModuleBuilder(templateFile, metadata, project, null, new ArrayList<ModuleWizardStep>(), (Disposable)ApplicationManager.getApplication(), true));
            this.myTemplateMetadata = metadata;
        }

        public String getName() {
            String title = this.myTemplateMetadata.getTitle();
            assert (title != null);
            return "Gradle: " + title;
        }

        public String getDescription() {
            return this.myTemplateMetadata.getDescription();
        }
    }
}

