/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.templates.TemplateUtils;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;

final class ReformattingGradleSyncListener
extends NewProjectImportGradleSyncListener {
    private final Collection<File> myTargetFiles;
    private final Collection<File> myFilesToOpen;

    ReformattingGradleSyncListener(Collection<File> targetFiles, Collection<File> filesToOpen) {
        this.myTargetFiles = targetFiles;
        this.myFilesToOpen = filesToOpen;
    }

    @Override
    public void syncSucceeded(final Project project) {
        StartupManagerEx manager = StartupManagerEx.getInstanceEx((Project)project);
        if (manager.postStartupActivityPassed()) {
            this.reformatRearrangeAndOpen(project);
        } else {
            manager.registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    ReformattingGradleSyncListener.this.reformatRearrangeAndOpen(project);
                }
            });
        }
    }

    private void reformatRearrangeAndOpen(Project project) {
        TemplateUtils.reformatAndRearrange(project, this.myTargetFiles);
        TemplateUtils.openEditors(project, this.myFilesToOpen, true);
    }
}

