/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.NewFormFactorModulePath;
import com.android.tools.idea.npw.ReformattingGradleSyncListener;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class NewProjectWizardDynamic
extends DynamicWizard {
    private static final String ERROR_MSG_TITLE = "Error in New Project Wizard";
    private Project myProject;

    public NewProjectWizardDynamic(Project project, Module module) {
        super(project, module, "New Project");
        this.setTitle("Create New Project");
    }

    @Override
    public void init() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            throw new IllegalStateException("Android SDK missing");
        }
        this.addPaths();
        this.initState();
        super.init();
    }

    protected void addPaths() {
        this.addPath(new ConfigureAndroidProjectPath(this.getDisposable()));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            this.addPath(path);
        }
    }

    protected void initState() {
        NewProjectWizardDynamic.initState(this.getState(), "1.5.0");
    }

    static void initState(ScopedStateStore state, String gradlePluginVersion) {
        AndroidSdkData data;
        state.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, gradlePluginVersion);
        state.put(WizardConstants.GRADLE_VERSION_KEY, "2.8");
        state.put(WizardConstants.IS_GRADLE_PROJECT_KEY, true);
        state.put(WizardConstants.IS_NEW_PROJECT_KEY, true);
        state.put(WizardConstants.TARGET_FILES_KEY, new HashSet());
        state.put(WizardConstants.FILES_TO_OPEN_KEY, new ArrayList());
        state.put(WizardConstants.USE_PER_MODULE_REPOS_KEY, false);
        try {
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception exception) {
            LOG.warn("Could not create debug keystore", (Throwable)exception);
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, "");
        }
        String mavenUrl = System.getProperty("android.mavenRepoUrl");
        if (mavenUrl != null) {
            state.put(WizardConstants.MAVEN_URL_KEY, mavenUrl);
        }
        if ((data = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
            state.put(WizardConstants.SDK_DIR_KEY, data.getLocation().getPath());
        }
    }

    @Override
    protected String getWizardActionDescription() {
        return String.format("Create %1$s", this.getState().get(WizardConstants.APPLICATION_NAME_KEY));
    }

    @Override
    public void performFinishingActions() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                NewProjectWizardDynamic.this.runFinish();
            }
        });
    }

    private void runFinish() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
        String rootPath = this.getState().get(WizardConstants.PROJECT_LOCATION_KEY);
        if (rootPath == null) {
            LOG.error("No root path specified for project");
            return;
        }
        File rootLocation = new File(rootPath);
        File wrapperPropertiesFilePath = GradleUtil.getGradleWrapperPropertiesFilePath(rootLocation);
        try {
            GradleUtil.updateGradleDistributionUrl("2.8", wrapperPropertiesFilePath);
        }
        catch (IOException e) {
            LOG.warn("Failed to update Gradle wrapper file", (Throwable)e);
        }
        String projectName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (projectName == null) {
            projectName = "Unnamed Project";
        }
        LanguageLevel initialLanguageLevel = null;
        Iterator<FormFactorUtils.FormFactor> iterator = FormFactorUtils.FormFactor.iterator();
        while (iterator.hasNext()) {
            LanguageLevel level;
            FormFactorUtils.FormFactor factor = iterator.next();
            String version = this.getState().get(FormFactorUtils.getLanguageLevelKey(factor));
            if (version == null || (level = LanguageLevel.parse((String)version.toString())) == null || initialLanguageLevel != null && !level.isAtLeast(initialLanguageLevel)) continue;
            initialLanguageLevel = level;
        }
        try {
            Collection<File> targetFiles = this.myState.get(WizardConstants.TARGET_FILES_KEY);
            assert (targetFiles != null);
            Collection filesToOpen = this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
            assert (filesToOpen != null);
            ReformattingGradleSyncListener listener = new ReformattingGradleSyncListener(targetFiles, filesToOpen);
            projectImporter.importNewlyCreatedProject(projectName, rootLocation, listener, this.myProject, initialLanguageLevel);
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error((Throwable)e);
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected String getProgressTitle() {
        return "Creating project...";
    }

    @Override
    protected void doFinish() throws IOException {
        final String location = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        String name = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        assert (location != null && name != null);
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                VfsUtil.createDirectoryIfMissing((String)location);
            }
        }.execute();
        this.myProject = ProjectManager.getInstance().createProject(name, location);
        super.doFinish();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }
}

