/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.IconStep;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateParameterStep2;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.RecentsManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AddAndroidActivityPath
extends DynamicWizardPath {
    public static final ScopedStateStore.Key<Boolean> KEY_IS_LAUNCHER = ScopedStateStore.createKey("is.launcher.activity", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final ScopedStateStore.Key<TemplateEntry> KEY_SELECTED_TEMPLATE = ScopedStateStore.createKey("selected.template", ScopedStateStore.Scope.PATH, TemplateEntry.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_MIN_SDK = ScopedStateStore.createKey("minApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_TARGET_API = ScopedStateStore.createKey("targetApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<Integer> KEY_BUILD_SDK = ScopedStateStore.createKey("buildApi", ScopedStateStore.Scope.PATH, Integer.class);
    public static final ScopedStateStore.Key<String> KEY_PACKAGE_NAME = ScopedStateStore.createKey("packageName", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<SourceProvider> KEY_SOURCE_PROVIDER = ScopedStateStore.createKey("source.provider", ScopedStateStore.Scope.PATH, SourceProvider.class);
    public static final ScopedStateStore.Key<String> KEY_SOURCE_PROVIDER_NAME = ScopedStateStore.createKey("sourceProviderName", ScopedStateStore.Scope.PATH, String.class);
    public static final Set<String> PACKAGE_NAME_PARAMETERS = ImmutableSet.of((Object)"packageName");
    public static final Set<String> CLASS_NAME_PARAMETERS = ImmutableSet.of((Object)"parentActivityClass");
    public static final ScopedStateStore.Key<Boolean> KEY_OPEN_EDITORS = ScopedStateStore.createKey("open.editors", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final Set<ScopedStateStore.Key<?>> IMPLICIT_PARAMETERS = ImmutableSet.of(KEY_PACKAGE_NAME, KEY_SOURCE_PROVIDER_NAME);
    private static final Logger LOG = Logger.getInstance(AddAndroidActivityPath.class);
    public static final String CUSTOMIZE_ACTIVITY_TITLE = "Customize the Activity";
    private TemplateParameterStep2 myParameterStep;
    private final boolean myIsNewModule;
    private IconStep myAssetStudioStep;
    private final VirtualFile myTargetFolder;
    private File myTemplate;
    private final Map<String, Object> myPredefinedParameterValues;
    private final Disposable myParentDisposable;

    public AddAndroidActivityPath(VirtualFile targetFolder, File template, Map<String, Object> predefinedParameterValues, Disposable parentDisposable) {
        this.myTemplate = template;
        this.myPredefinedParameterValues = predefinedParameterValues;
        this.myParentDisposable = parentDisposable;
        this.myIsNewModule = false;
        this.myTargetFolder = targetFolder != null && !targetFolder.isDirectory() ? targetFolder.getParent() : targetFolder;
    }

    private static FormFactorUtils.FormFactor getFormFactor(VirtualFile targetFolder) {
        return FormFactorUtils.FormFactor.MOBILE;
    }

    public static File findSrcDirectory(SourceProvider sourceProvider) {
        return (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
    }

    private static File findTestDirectory(Module module) {
        List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
        return testsRoot.size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
    }

    public static File findResDirectory(SourceProvider sourceProvider) {
        Collection resDirectories = sourceProvider.getResDirectories();
        File resDir = null;
        if (!resDirectories.isEmpty()) {
            resDir = (File)resDirectories.iterator().next();
        }
        return resDir;
    }

    public static File findAidlDir(SourceProvider sourceProvider) {
        Collection aidlDirectories = sourceProvider.getAidlDirectories();
        File resDir = null;
        if (!aidlDirectories.isEmpty()) {
            resDir = (File)aidlDirectories.iterator().next();
        }
        return resDir;
    }

    public static File findManifestDirectory(SourceProvider sourceProvider) {
        File manifestFile = sourceProvider.getManifestFile();
        File manifestDir = manifestFile.getParentFile();
        if (manifestDir != null) {
            return manifestDir;
        }
        return null;
    }

    private static File getModuleRoot(Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        return null;
    }

    private static Map<String, Object> selectSourceProvider(SourceProvider sourceProvider, AndroidModel androidModel, Module module, String packageName) {
        File aidlDir;
        File manifestDir;
        HashMap paths = Maps.newHashMap();
        File moduleDirPath = androidModel.getRootDirPath();
        File javaDir = AddAndroidActivityPath.findSrcDirectory(sourceProvider);
        File testDir = AddAndroidActivityPath.findTestDirectory(module);
        String javaPath = AddAndroidActivityPath.getJavaPath(moduleDirPath, javaDir);
        paths.put("srcDir", javaPath);
        File resDir = AddAndroidActivityPath.findResDirectory(sourceProvider);
        if (resDir != null) {
            String resPath = FileUtil.getRelativePath((File)moduleDirPath, (File)resDir);
            if (resPath != null) {
                resPath = FileUtil.toSystemIndependentName((String)resPath);
            }
            paths.put("resDir", resPath);
            paths.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = AddAndroidActivityPath.findManifestDirectory(sourceProvider)) != null) {
            String manifestPath = FileUtil.getRelativePath((File)moduleDirPath, (File)manifestDir);
            paths.put("manifestDir", manifestPath);
            paths.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = AddAndroidActivityPath.findAidlDir(sourceProvider)) != null) {
            String aidlPath = FileUtil.getRelativePath((File)moduleDirPath, (File)aidlDir);
            paths.put("aidlDir", aidlPath);
            paths.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        if (testDir == null) {
            VirtualFile rootDir = androidModel.getRootDir();
            String absolutePath = Joiner.on((char)'/').join((Object)rootDir.getPath(), (Object)TemplateWizard.TEST_SOURCE_PATH, new Object[]{"java"});
            testDir = new File(FileUtil.toSystemDependentName((String)absolutePath));
        }
        assert (javaPath != null);
        String sourceRootPackagePrefix = AddAndroidActivityPath.getSourceDirectoryPackagePrefix(module, javaDir);
        String relativePackageName = AddAndroidActivityPath.removeCommonPackagePrefix(sourceRootPackagePrefix, packageName);
        paths.put("packageName", packageName);
        String relativePackageDir = relativePackageName.replace('.', File.separatorChar);
        File srcOut = new File(javaDir, relativePackageDir);
        File testOut = new File(testDir, relativePackageDir);
        paths.put("testDir", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        paths.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getAbsolutePath()));
        paths.put("applicationPackage", ManifestInfo.get(module, false).getPackage());
        paths.put("srcOut", FileUtil.toSystemIndependentName((String)srcOut.getAbsolutePath()));
        return paths;
    }

    private static String getSourceDirectoryPackagePrefix(Module module, File javaDir) {
        VirtualFile javaVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(javaDir);
        if (javaVirtualFile == null) {
            return "";
        }
        SourceFolder sourceFolder = ProjectRootsUtil.findSourceFolder((Module)module, (VirtualFile)javaVirtualFile);
        if (sourceFolder == null) {
            return "";
        }
        return sourceFolder.getPackagePrefix();
    }

    static String removeCommonPackagePrefix(String packagePrefix, String packageName) {
        String relativePackageName = packageName;
        if (packageName.equals(packagePrefix)) {
            relativePackageName = "";
        } else if (packageName.length() > packagePrefix.length() && packageName.startsWith(packagePrefix) && packageName.charAt(packagePrefix.length()) == '.') {
            relativePackageName = relativePackageName.substring(packagePrefix.length() + 1);
        }
        return relativePackageName;
    }

    private static String getJavaPath(File ioModuleDir, File javaDir) {
        String javaPath = null;
        if (javaDir != null && (javaPath = FileUtil.getRelativePath((File)ioModuleDir, (File)javaDir)) != null) {
            javaPath = FileUtil.toSystemIndependentName((String)javaPath);
        }
        return javaPath;
    }

    public static List<String> getParameterValueHistory(Parameter parameter, Project project) {
        List entries = RecentsManager.getInstance((Project)project).getRecentEntries(AddAndroidActivityPath.getRecentHistoryKey(parameter.id));
        return entries == null ? ImmutableList.of() : entries;
    }

    public static String getRecentHistoryKey(String parameter) {
        return "android.template." + parameter;
    }

    public static void saveRecentValues(Project project, Map<String, Object> state) {
        for (String id : Iterables.concat(PACKAGE_NAME_PARAMETERS, CLASS_NAME_PARAMETERS)) {
            String value = (String)state.get(id);
            if (StringUtil.isEmpty((String)value)) continue;
            RecentsManager.getInstance((Project)project).registerRecentEntry(AddAndroidActivityPath.getRecentHistoryKey(id), value);
        }
    }

    @Override
    protected void init() {
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            this.myState.put(KEY_BUILD_SDK, platform.getTarget().getVersion().getFeatureLevel());
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        this.myState.put(KEY_MIN_SDK, minSdkVersion);
        this.myState.put(KEY_TARGET_API, moduleInfo.getTargetSdkVersion());
        this.myState.put(KEY_PACKAGE_NAME, this.getInitialPackageName(module, facet));
        this.myState.put(KEY_OPEN_EDITORS, true);
        if (this.myTemplate == null) {
            FormFactorUtils.FormFactor formFactor = AddAndroidActivityPath.getFormFactor(this.myTargetFolder);
            this.myState.put(FormFactorUtils.getMinApiLevelKey(formFactor), minSdkVersion.getApiLevel());
            this.myState.put(FormFactorUtils.getBuildApiLevelKey(formFactor), moduleInfo.getTargetSdkVersion().getApiLevel());
            ActivityGalleryStep galleryStep = new ActivityGalleryStep(formFactor, false, KEY_SELECTED_TEMPLATE, module, this.myParentDisposable);
            this.addStep(galleryStep);
        } else {
            TemplateMetadata templateMetadata = TemplateManager.getInstance().getTemplate(this.myTemplate);
            assert (templateMetadata != null);
            this.myState.put(KEY_SELECTED_TEMPLATE, new TemplateEntry(this.myTemplate, templateMetadata));
        }
        SourceProvider[] sourceProviders = AddAndroidActivityPath.getSourceProviders(module, this.myTargetFolder);
        this.myParameterStep = new TemplateParameterStep2(AddAndroidActivityPath.getFormFactor(this.myTargetFolder), this.myPredefinedParameterValues, this.myParentDisposable, KEY_PACKAGE_NAME, sourceProviders, CUSTOMIZE_ACTIVITY_TITLE);
        this.myAssetStudioStep = new IconStep(KEY_SELECTED_TEMPLATE, KEY_SOURCE_PROVIDER, this.myParentDisposable);
        this.addStep(this.myParameterStep);
        this.addStep(this.myAssetStudioStep);
    }

    public static SourceProvider[] getSourceProviders(Module module, VirtualFile targetDirectory) {
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            List<SourceProvider> providers = targetDirectory != null ? IdeaSourceProvider.getSourceProvidersForFile(facet, targetDirectory, facet.getMainSourceProvider()) : IdeaSourceProvider.getAllSourceProviders(facet);
            return (SourceProvider[])ArrayUtil.toObjectArray(providers, SourceProvider.class);
        }
        return new SourceProvider[0];
    }

    private String getInitialPackageName(Module module, AndroidFacet facet) {
        if (this.myTargetFolder != null) {
            String packageName;
            File srcDirectory;
            List<SourceProvider> sourceProviders = IdeaSourceProvider.getSourceProvidersForFile(facet, this.myTargetFolder, facet.getMainSourceProvider());
            File targetDirectoryFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myTargetFolder);
            if (sourceProviders.size() > 0 && IdeaSourceProvider.containsFile(sourceProviders.get(0), targetDirectoryFile) && (srcDirectory = AddAndroidActivityPath.findSrcDirectory(sourceProviders.get(0))) != null && (packageName = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getPackageNameByDirectory(this.myTargetFolder)) != null) {
                return packageName;
            }
        }
        return this.getApplicationPackageName();
    }

    @Override
    public String getPathName() {
        return "Add Android activity";
    }

    @Override
    public boolean canPerformFinishingActions() {
        return this.performFinishingOperation(true, null, null);
    }

    @Override
    public boolean performFinishingActions() {
        ArrayList filesToReformat;
        final Project project = this.getProject();
        assert (project != null);
        final ArrayList filesToOpen = Lists.newArrayList();
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Activity", new PsiFile[0], (List)(filesToReformat = Lists.newArrayList())){
            final /* synthetic */ List val$filesToReformat;
            {
                this.val$filesToReformat = list2;
                super(x0, x1, x2);
            }

            protected void run(Result<Boolean> result) throws Throwable {
                boolean success = AddAndroidActivityPath.this.performFinishingOperation(false, filesToOpen, this.val$filesToReformat);
                if (success) {
                    AddAndroidActivityPath.this.myAssetStudioStep.createAssets();
                }
                result.setResult((Object)success);
            }
        }.execute().getResultObject();
        if (!success) {
            return false;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateUtils.reformatAndRearrange(project, filesToReformat);
                if (Boolean.TRUE.equals(AddAndroidActivityPath.this.myState.get(KEY_OPEN_EDITORS))) {
                    TemplateUtils.openEditors(project, filesToOpen, true);
                }
            }
        });
        return true;
    }

    private boolean performFinishingOperation(boolean dryRun, List<File> filesToOpen, List<File> filesToReformat) {
        TemplateEntry templateEntry = this.myState.get(KEY_SELECTED_TEMPLATE);
        Project project = this.getProject();
        Module module = this.getModule();
        assert (templateEntry != null);
        assert (project != null && module != null);
        Template template = templateEntry.getTemplate();
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(module);
        if (moduleRoot == null) {
            return false;
        }
        Map<String, Object> parameterMap = this.getTemplateParameterMap(templateEntry.getMetadata());
        AddAndroidActivityPath.saveRecentValues(project, parameterMap);
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Activity").withDryRun(dryRun).withShowErrors(true).withModule(module).withParams(parameterMap).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
        return template.render(context);
    }

    private Map<String, Object> getTemplateParameterMap(TemplateMetadata template) {
        HashMap parameterValueMap = Maps.newHashMap();
        parameterValueMap.put("isNewProject", this.myIsNewModule);
        parameterValueMap.putAll(this.getDirectories());
        for (ScopedStateStore.Key<?> key : IMPLICIT_PARAMETERS) {
            parameterValueMap.put(key.name, this.myState.get(key));
        }
        for (Parameter parameter : template.getParameters()) {
            parameterValueMap.put(parameter.id, this.myState.get(this.myParameterStep.getParameterKey(parameter)));
        }
        try {
            parameterValueMap.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
        }
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(this.getModule());
        if (moduleRoot != null) {
            parameterValueMap.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        }
        if (Objects.equal((Object)this.getApplicationPackageName(), parameterValueMap.get("packageName"))) {
            parameterValueMap.remove("applicationPackage");
        }
        return parameterValueMap;
    }

    private String getApplicationPackageName() {
        AndroidModel androidModel = AndroidFacet.getInstance(this.getModule()).getAndroidModel();
        assert (androidModel != null);
        return androidModel.getApplicationId();
    }

    private Map<String, Object> getDirectories() {
        HashMap templateParameters = Maps.newHashMap();
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            templateParameters.put("buildApi", platform.getTarget().getVersion().getFeatureLevel());
            templateParameters.put("buildApiString", TemplateMetadata.getBuildApiString(platform.getTarget().getVersion()));
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidModel androidModel = facet.getAndroidModel();
        SourceProvider sourceProvider1 = this.myState.get(KEY_SOURCE_PROVIDER);
        if (sourceProvider1 != null && androidModel != null) {
            String packageName = this.myState.get(KEY_PACKAGE_NAME);
            assert (packageName != null);
            templateParameters.putAll(AddAndroidActivityPath.selectSourceProvider(sourceProvider1, androidModel, module, packageName));
        }
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion.getApiString();
        templateParameters.put("minApi", minSdkName);
        templateParameters.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        templateParameters.put("minApiLevel", minSdkVersion.getFeatureLevel());
        templateParameters.put("isLibraryProject", facet.isLibraryProject());
        try {
            templateParameters.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getDebugKeystore(facet)));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateParameters.put("debugKeystoreSha1", "");
        }
        String projectLocation = "projectLocation";
        Project project = this.getProject();
        assert (project != null);
        templateParameters.put(projectLocation, project.getBasePath());
        String moduleName = new File(module.getModuleFilePath()).getParentFile().getName();
        templateParameters.put("projectName", moduleName);
        return templateParameters;
    }

    public String getActionDescription() {
        TemplateEntry template = this.myState.get(KEY_SELECTED_TEMPLATE);
        return String.format("Add %1$s", template == null ? "Template" : template.getTitle());
    }
}

