/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.nodes.AndroidResComparator;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidResGroupNode
extends ProjectViewNode<List<PsiFile>>
implements DirectoryGroupNode,
Comparable {
    private final String myResName;
    private final AndroidFacet myFacet;
    private final List<PsiFile> myFiles;

    public AndroidResGroupNode(Project project, AndroidFacet facet, List<PsiFile> files, String resName, ViewSettings settings) {
        super(project, files, settings);
        this.myResName = resName;
        this.myFacet = facet;
        this.myFiles = files;
    }

    @Override
    public PsiDirectory[] getDirectories() {
        List psiFiles = (List)this.getValue();
        PsiDirectory[] folders = new PsiDirectory[psiFiles.size()];
        for (int i = 0; i < psiFiles.size(); ++i) {
            folders[i] = ((PsiFile)psiFiles.get(i)).getParent();
        }
        return folders;
    }

    public boolean contains(VirtualFile file) {
        for (PsiFile psiFile : this.myFiles) {
            if (!psiFile.getVirtualFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)this.myFiles.size());
        for (PsiFile file : this.myFiles) {
            children.add(new AndroidResFileNode(this.myProject, file, this.getSettings(), this.myFacet));
        }
        return children;
    }

    public int getWeight() {
        return 20;
    }

    public Comparable getSortKey() {
        return this;
    }

    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(Object obj) {
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    public String getResName() {
        return this.myResName;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        if (this.myFiles.isEmpty()) {
            return;
        }
        PsiFile fileToOpen = AndroidResGroupNode.findFileToOpen(this.myFiles);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.myProject, fileToOpen.getVirtualFile()).navigate(requestFocus);
    }

    private static PsiFile findFileToOpen(List<PsiFile> files) {
        PsiFile bestFile = null;
        FolderConfiguration bestConfig = null;
        for (PsiFile file : files) {
            PsiDirectory qualifiedDirectory = file.getParent();
            assert (qualifiedDirectory != null) : "Resource file's parent directory cannot be null";
            FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)qualifiedDirectory.getName());
            if (bestConfig != null && config != null && config.compareTo(bestConfig) >= 0) continue;
            bestConfig = config;
            bestFile = file;
        }
        return bestFile;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(this.myResName);
        presentation.addText(this.myResName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myFiles.size() > 1) {
            presentation.addText(String.format(" (%1$d)", this.myFiles.size()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        StringBuilder sb = new StringBuilder(this.myResName);
        sb.append(" (");
        sb.append(this.myFiles.size());
        sb.append(")");
        return sb.toString();
    }
}

