/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.navigator.AndroidTreeUpdater;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class AndroidProjectTreeBuilder
extends ProjectTreeBuilder {
    private Map<VirtualFile, AbstractTreeNode> myFileToNodeMap = Maps.newHashMap();

    public AndroidProjectTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, Comparator<NodeDescriptor> comparator, ProjectAbstractTreeStructureBase treeStructure) {
        super(project, tree, treeModel, comparator, treeStructure);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    AndroidProjectTreeBuilder.this.removeMapping(vFileEvent.getFile());
                }
            }
        });
    }

    protected AbstractTreeUpdater createUpdater() {
        return new AndroidTreeUpdater(this.getTreeStructure(), this);
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Object findNodeByElement(Object element) {
        if (element == null) {
            return null;
        }
        Object node = super.findNodeByElement(element);
        if (node != null) {
            return node;
        }
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        AbstractTreeNode treeNode = this.getNodeForFile(virtualFile);
        if (treeNode == null) {
            return null;
        }
        Object parentNode = this.findNodeByElement(treeNode.getParent());
        if (!(parentNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Enumeration<TreeNode> children = ((DefaultMutableTreeNode)parentNode).children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!(child.getUserObject() instanceof DirectoryGroupNode)) continue;
            for (PsiDirectory folder : ((DirectoryGroupNode)child.getUserObject()).getDirectories()) {
                if (!folder.getVirtualFile().equals(virtualFile)) continue;
                return child;
            }
        }
        return null;
    }

    public void createMapping(VirtualFile file, AbstractTreeNode node) {
        this.myFileToNodeMap.put(file, node);
    }

    private void removeMapping(VirtualFile file) {
        this.myFileToNodeMap.remove(file);
    }

    private AbstractTreeNode getNodeForFile(VirtualFile file) {
        return this.myFileToNodeMap.get(file);
    }
}

