/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.memory;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.monitor.DeviceSampler;

public class MemorySampler
extends DeviceSampler
implements AndroidDebugBridge.IClientChangeListener {
    public static final int SAMPLES = 2048;
    private boolean myRequestPending;

    MemorySampler(int sampleFrequencyMs) {
        super(new TimelineData(2, 2048), sampleFrequencyMs);
    }

    @Override
    public void start() {
        if (this.myExecutingTask == null && this.myClient != null) {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.myRequestPending = false;
        if (this.myExecutingTask != null) {
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        }
    }

    @Override
    public String getName() {
        return "Memory Sampler";
    }

    protected void recordSample(int type) {
        float freeMb = 0.0f;
        float allocMb = 0.0f;
        if (this.myClient != null) {
            ClientData.HeapInfo m = this.myClient.getClientData().getVmHeapInfo(1);
            if (m != null) {
                allocMb = (float)m.bytesAllocated / 1048576.0f;
                freeMb = (float)m.sizeInBytes / 1048576.0f - allocMb;
            }
        } else {
            type = 0;
        }
        this.myTimelineData.add(System.currentTimeMillis(), type, new float[]{allocMb, freeMb});
    }

    protected void requestSample() {
        Client client = this.myClient;
        if (client != null) {
            client.updateHeapInfo();
        }
    }

    @Override
    protected void sample(boolean forced) throws InterruptedException {
        if (forced) {
            this.myRequestPending = false;
            this.recordSample(1);
        } else {
            if (this.myRequestPending) {
                this.recordSample(2);
            }
            this.requestSample();
            this.myRequestPending = true;
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if (this.myClient != null && this.myClient == client && (changeMask & 0x40) != 0) {
            this.forceSample();
        }
    }
}

