/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.cpu;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.monitor.DeviceSampler;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CpuSampler
extends DeviceSampler {
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_NOT_FOUND = 4;
    public static final int SAMPLES = 2048;
    private static final Logger LOG = Logger.getInstance(CpuSampler.class);
    private Long previousKernelUsage = null;
    private Long previousUserUsage = null;
    private Long previousTotalUptime = null;

    public CpuSampler(int sampleFrequencyMs) {
        super(new TimelineData(2, 2048), sampleFrequencyMs);
    }

    @Override
    public String getName() {
        return "CPU Sampler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sample(boolean forced) throws InterruptedException {
        if (this.myClient == null) {
            return;
        }
        IDevice device = this.myClient.getDevice();
        ClientData data = this.myClient.getClientData();
        Long kernelCpuUsage = null;
        Long userCpuUsage = null;
        Long totalUptime = null;
        int type = 1;
        if (device != null) {
            try {
                int pid = data.getPid();
                ProcessStatReceiver dumpsysReceiver = new ProcessStatReceiver(pid);
                device.executeShellCommand("cat /proc/" + pid + "/stat", (IShellOutputReceiver)dumpsysReceiver, 1L, TimeUnit.SECONDS);
                kernelCpuUsage = dumpsysReceiver.getKernelCpuUsage();
                userCpuUsage = dumpsysReceiver.getUserCpuUsage();
                SystemStatReceiver systemStatReceiver = new SystemStatReceiver();
                device.executeShellCommand("cat /proc/stat", (IShellOutputReceiver)systemStatReceiver, 1L, TimeUnit.SECONDS);
                totalUptime = systemStatReceiver.getTotalUptime();
            }
            catch (TimeoutException e) {
                type = 2;
            }
            catch (AdbCommandRejectedException e) {
                type = 3;
            }
            catch (ShellCommandUnresponsiveException e) {
                type = 0;
            }
            catch (IOException e) {
                type = 0;
            }
        }
        if (kernelCpuUsage != null && userCpuUsage != null && totalUptime != null) {
            long totalTimeDiff;
            if (this.previousKernelUsage != null && this.previousUserUsage != null && this.previousTotalUptime != null && (totalTimeDiff = totalUptime - this.previousTotalUptime) > 0L) {
                float kernelPercentUsage = (float)(kernelCpuUsage - this.previousKernelUsage) * 100.0f / (float)totalTimeDiff;
                kernelPercentUsage = Math.max(Math.min(kernelPercentUsage, 100.0f), 0.0f);
                float userPercentUsage = (float)(userCpuUsage - this.previousUserUsage) * 100.0f / (float)totalTimeDiff;
                userPercentUsage = Math.max(Math.min(userPercentUsage, 100.0f), 0.0f);
                this.myTimelineData.add(System.currentTimeMillis(), type, new float[]{kernelPercentUsage, userPercentUsage});
            }
            this.previousKernelUsage = kernelCpuUsage;
            this.previousUserUsage = userCpuUsage;
            this.previousTotalUptime = totalUptime;
        } else {
            TimelineData timelineData;
            TimelineData timelineData2 = timelineData = this.myTimelineData;
            synchronized (timelineData2) {
                if (timelineData.size() > 0) {
                    TimelineData.Sample lastSample = timelineData.get(timelineData.size() - 1);
                    timelineData.add(System.currentTimeMillis(), 4, new float[]{lastSample.values[0], lastSample.values[1]});
                }
            }
        }
    }

    static final class SystemStatReceiver
    extends MultiLineReceiver {
        private Long myTotalUptime = null;

        SystemStatReceiver() {
        }

        public Long getTotalUptime() {
            return this.myTotalUptime;
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(String[] lines) {
            long totalUptime = 0L;
            String[] tokens = lines[0].split("\\s+");
            if (tokens.length < 11 || !tokens[0].equals("cpu")) {
                return;
            }
            for (int i = 1; i < tokens.length; ++i) {
                totalUptime += Long.parseLong(tokens[i]);
            }
            this.myTotalUptime = totalUptime;
        }
    }

    static final class ProcessStatReceiver
    extends MultiLineReceiver {
        private final int myPid;
        private Long myUserCpuTicks;
        private Long myKernelCpuTicks;

        private ProcessStatReceiver(int pid) {
            this.myPid = pid;
        }

        public Long getUserCpuUsage() {
            return this.myUserCpuTicks;
        }

        public Long getKernelCpuUsage() {
            return this.myKernelCpuTicks;
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(String[] lines) {
            String[] tokens = lines[0].split("\\s+");
            if (tokens.length >= 15) {
                Integer pid = Integer.parseInt(tokens[0]);
                if (pid != this.myPid) {
                    LOG.warn("Invalid pid.");
                    return;
                }
                this.myUserCpuTicks = Long.parseLong(tokens[13]);
                this.myKernelCpuTicks = Long.parseLong(tokens[14]);
            }
        }
    }
}

