/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.cpu;

import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ToggleMethodProfilingAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.cpu.CpuSampler;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;

public class CpuMonitorView
extends BaseMonitorView<CpuSampler>
implements TimelineEventListener,
DeviceContext.DeviceSelectionListener {
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 100.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = 100.0f;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 10.0f;

    public CpuMonitorView(Project project, DeviceContext deviceContext) {
        super(project, deviceContext, new CpuSampler(500), 0.75f, 100.0f, 100.0f, 10.0f);
        this.myTimelineComponent.configureUnits("%");
        this.myTimelineComponent.configureStream(0, "Kernel", (Color)new JBColor(14106431, 14106431));
        this.myTimelineComponent.configureStream(1, "User", (Color)new JBColor(15441823, 10308684));
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.setViewComponent((JComponent)this.myTimelineComponent);
    }

    @Override
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new ToggleMethodProfilingAction(this.myProject, this.myDeviceContext));
        return group;
    }

    @Override
    public String getMonitorName() {
        return "CpuMonitor";
    }

    @Override
    public String getDescription() {
        return "cpu usage";
    }
}

