/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class DeviceSampler
implements Runnable {
    public static final int TYPE_UNREACHABLE = 0;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_TIMEOUT = 2;
    public static final int INHERITED_TYPE_START = 3;
    protected TimelineData myTimelineData;
    protected final List<TimelineEventListener> myListeners = Lists.newLinkedList();
    protected int mySampleFrequencyMs;
    protected volatile Future<?> myExecutingTask;
    protected volatile Client myClient;
    private final Semaphore myDataSemaphore;
    protected volatile boolean myRunning;
    protected volatile CountDownLatch myTaskStatus;
    protected volatile boolean myIsPaused;

    public DeviceSampler(TimelineData timelineData, int sampleFrequencyMs) {
        this.myTimelineData = timelineData;
        this.mySampleFrequencyMs = sampleFrequencyMs;
        this.myDataSemaphore = new Semaphore(0, true);
    }

    public void start() {
        if (this.myExecutingTask == null && this.myClient != null) {
            this.myRunning = true;
            this.myTaskStatus = new CountDownLatch(1);
            this.myExecutingTask = ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            this.myClient.setHeapInfoUpdateEnabled(true);
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStart();
            }
        }
    }

    public void stop() {
        if (this.myExecutingTask != null) {
            this.myRunning = false;
            this.myDataSemaphore.release();
            this.myExecutingTask.cancel(true);
            try {
                this.myTaskStatus.await();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (this.myClient != null) {
                this.myClient.setHeapInfoUpdateEnabled(false);
            }
            this.myExecutingTask = null;
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStop();
            }
        }
    }

    public TimelineData getTimelineData() {
        return this.myTimelineData;
    }

    protected boolean requiresSamplerRestart(Client client) {
        return client != this.myClient;
    }

    public final void setClient(Client client) {
        if (this.requiresSamplerRestart(client)) {
            this.stop();
            this.myClient = client;
            this.prepareSampler(client);
            this.myTimelineData.clear();
            if (!this.myIsPaused) {
                this.start();
            }
        }
    }

    public final void setIsPaused(boolean paused) {
        this.myIsPaused = paused;
        if (this.myIsPaused) {
            if (this.myClient != null) {
                this.stop();
            }
        } else {
            this.myTimelineData.clear();
            this.prepareSampler(this.myClient);
            this.start();
        }
    }

    public final boolean getIsPaused() {
        return this.myIsPaused;
    }

    protected void prepareSampler(Client client) {
    }

    public Client getClient() {
        return this.myClient;
    }

    public void addListener(TimelineEventListener listener) {
        this.myListeners.add(listener);
    }

    public boolean isRunning() {
        return this.myExecutingTask != null && this.myRunning;
    }

    protected void forceSample() {
        this.myDataSemaphore.release();
    }

    @Override
    public void run() {
        long timeToWait = this.mySampleFrequencyMs;
        while (this.myRunning) {
            try {
                Client client;
                long start = System.currentTimeMillis();
                boolean acquired = this.myDataSemaphore.tryAcquire(timeToWait, TimeUnit.MILLISECONDS);
                if (this.myRunning && !this.myIsPaused) {
                    this.sample(acquired);
                }
                if ((timeToWait -= System.currentTimeMillis() - start) <= 0L) {
                    timeToWait = this.mySampleFrequencyMs;
                }
                if ((client = this.myClient) != null && client.isValid()) continue;
                this.stop();
            }
            catch (InterruptedException e) {
                this.myRunning = false;
            }
        }
        this.myTaskStatus.countDown();
    }

    public abstract String getName();

    protected abstract void sample(boolean var1) throws InterruptedException;
}

