/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.chartlib.EventData;
import com.android.tools.chartlib.TimelineComponent;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;

public abstract class BaseMonitorView<T extends DeviceSampler>
implements HierarchyListener,
TimelineEventListener,
DeviceContext.DeviceSelectionListener {
    private static final String PAUSED_KEY = ".paused";
    private static final String PAUSED_LABEL = "This monitor is disabled.";
    private static final Integer OVERLAY_LAYER = JLayeredPane.DEFAULT_LAYER + 10;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    protected static final int PAUSED_LABEL_PRIORITY = 5;
    protected Project myProject;
    protected DeviceContext myDeviceContext;
    protected JLayeredPane myContentPane;
    protected volatile TimelineComponent myTimelineComponent;
    protected final T mySampler;
    protected final EventData myEvents = new EventData();
    private JPanel myTextPanel;
    private JTextPane myOverlayText;
    private HashMap<String, ZOrderedOverlayText> myOverlayLookup;
    private PriorityQueue<ZOrderedOverlayText> myVisibleOverlays;

    protected BaseMonitorView(Project project, DeviceContext deviceContext, T sampler, float bufferTime, float initialMax, float absoluteMax, float initialMarkerSeparation) {
        this.myProject = project;
        this.myDeviceContext = deviceContext;
        this.myDeviceContext.addListener(this, (Disposable)project);
        this.mySampler = sampler;
        ((DeviceSampler)this.mySampler).addListener(this);
        this.myTimelineComponent = new TimelineComponent(((DeviceSampler)this.mySampler).getTimelineData(), this.myEvents, bufferTime, initialMax, absoluteMax, initialMarkerSeparation);
        this.myContentPane = new JBLayeredPane(){

            public void doLayout() {
                Component[] components = this.getComponents();
                Rectangle r = this.getBounds();
                for (Component c : components) {
                    c.setBounds(0, 0, r.width, r.height);
                }
            }

            public Dimension getPreferredSize() {
                return this.getBounds().getSize();
            }
        };
        this.myTextPanel = new JPanel(new GridBagLayout()){
            Color translucentBackgroundColor;
            {
                this.translucentBackgroundColor = ColorUtil.toAlpha((Color)BACKGROUND_COLOR, (int)192);
            }

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(this.translucentBackgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.myTextPanel.setOpaque(false);
        this.myOverlayText = new JTextPane();
        this.myOverlayText.setEditable(false);
        this.myOverlayText.setOpaque(false);
        this.myOverlayText.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myOverlayText.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myOverlayText.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myOverlayLookup = new HashMap();
        this.myVisibleOverlays = new PriorityQueue<ZOrderedOverlayText>(5, new Comparator<ZOrderedOverlayText>(){

            @Override
            public int compare(ZOrderedOverlayText a, ZOrderedOverlayText b) {
                return a.myZ - b.myZ;
            }
        });
        this.myTextPanel.add(this.myOverlayText);
        this.myTextPanel.setVisible(false);
        this.myContentPane.add(this.myTextPanel, OVERLAY_LAYER, 0);
        this.myContentPane.addHierarchyListener(this);
        this.addOverlayText(PAUSED_LABEL, 5);
        this.performPausing(this.getPausedSetting());
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !((DeviceSampler)this.mySampler).isRunning()) {
            ((DeviceSampler)this.mySampler).start();
        }
    }

    public ComponentWithActions createComponent() {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.myContentPane, "Center");
        return new ComponentWithActions.Impl(this.getToolbarActions(), null, null, null, (JComponent)wrapper);
    }

    public abstract ActionGroup getToolbarActions();

    public Project getProject() {
        return this.myProject;
    }

    public DeviceContext getDeviceContext() {
        return this.myDeviceContext;
    }

    public EventData getEvents() {
        return this.myEvents;
    }

    @Override
    public void clientSelected(Client c) {
        ((DeviceSampler)this.mySampler).setClient(c);
    }

    @Override
    public void deviceChanged(IDevice device, int changeMask) {
    }

    @Override
    public void deviceSelected(IDevice device) {
    }

    public void setPaused(boolean paused) {
        this.performPausing(paused);
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.getMonitorName() + PAUSED_KEY, Boolean.toString(paused));
    }

    public boolean isPaused() {
        return ((DeviceSampler)this.mySampler).getIsPaused();
    }

    @Override
    public void onStart() {
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                BaseMonitorView.this.setOverlayEnabled(BaseMonitorView.PAUSED_LABEL, false);
            }
        });
        this.myTimelineComponent.setUpdateData(true);
    }

    @Override
    public void onStop() {
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                BaseMonitorView.this.setOverlayEnabled(BaseMonitorView.PAUSED_LABEL, true);
            }
        });
        this.myTimelineComponent.setUpdateData(false);
    }

    public abstract String getMonitorName();

    public abstract String getDescription();

    protected final void addOverlayText(String text, int index) {
        assert (!this.myOverlayLookup.containsKey(text) && index >= 0 && index < Integer.MAX_VALUE);
        this.myOverlayLookup.put(text, new ZOrderedOverlayText(text, index));
    }

    protected final void setOverlayEnabled(String text, boolean enabled) {
        assert (this.myOverlayLookup.containsKey(text));
        ZOrderedOverlayText orderedText = this.myOverlayLookup.get(text);
        if (enabled) {
            if (!this.myVisibleOverlays.contains(orderedText)) {
                this.myVisibleOverlays.add(orderedText);
                this.updateOverlayText(this.myVisibleOverlays.peek().myText);
            }
        } else {
            this.myVisibleOverlays.remove(orderedText);
            if (this.myVisibleOverlays.size() > 0) {
                this.updateOverlayText(this.myVisibleOverlays.peek().myText);
            } else {
                this.updateOverlayText("");
            }
        }
    }

    protected final void setViewComponent(JComponent component) {
        this.myContentPane.add(component, JLayeredPane.DEFAULT_LAYER, 0);
    }

    protected boolean getPreferredPausedState() {
        return false;
    }

    private boolean getPausedSetting() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.getMonitorName() + PAUSED_KEY, this.getPreferredPausedState());
    }

    private void performPausing(boolean paused) {
        ((DeviceSampler)this.mySampler).setIsPaused(paused);
        this.setOverlayEnabled(PAUSED_LABEL, paused);
        this.myTimelineComponent.setUpdateData(!paused);
    }

    private void updateOverlayText(String text) {
        this.myOverlayText.setText(text);
        this.myTextPanel.setVisible(!text.isEmpty());
        this.myTextPanel.invalidate();
    }

    private static class ZOrderedOverlayText {
        private String myText;
        private int myZ;

        private ZOrderedOverlayText(String text, int z) {
            this.myText = text;
            this.myZ = z;
        }
    }
}

