/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidConfiguredLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import java.util.regex.Pattern;

final class ConfiguredFilter {
    private final String myName;
    private final Pattern myMessagePattern;
    private final Pattern myTagPattern;
    private final Pattern myPkgNamePattern;
    private final String myPid;
    private final Log.LogLevel myLogLevel;

    private ConfiguredFilter(String name, Pattern messagePattern, Pattern tagPattern, Pattern pkgNamePattern, String pid, Log.LogLevel logLevel) {
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
    }

    public boolean isApplicable(String message, String tag, String pkg, int pid, Log.LogLevel logLevel) {
        if (!(this.myMessagePattern == null || message != null && this.myMessagePattern.matcher(message).find())) {
            return false;
        }
        if (!(this.myTagPattern == null || tag != null && this.myTagPattern.matcher(tag).find())) {
            return false;
        }
        if (!(this.myPkgNamePattern == null || pkg != null && this.myPkgNamePattern.matcher(pkg).find())) {
            return false;
        }
        if (this.myPid != null && this.myPid.length() > 0 && !this.myPid.equals(Integer.toString(pid))) {
            return false;
        }
        return this.myLogLevel == null || logLevel != null && logLevel.getPriority() >= this.myLogLevel.getPriority();
    }

    public String getName() {
        return this.myName;
    }

    public static ConfiguredFilter compile(AndroidConfiguredLogFilters.FilterEntry entry, String name) {
        Pattern logMessagePattern = RegexFilterComponent.pattern(entry.getLogMessagePattern(), entry.getLogMessageIsRegex());
        Pattern logTagPattern = RegexFilterComponent.pattern(entry.getLogTagPattern(), entry.getLogTagIsRegex());
        Pattern pkgNamePattern = RegexFilterComponent.pattern(entry.getPackageNamePattern(), entry.getPackageNameIsRegex());
        String pid = entry.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = entry.getLogLevel();
        if (logLevelStr != null && logLevelStr.length() > 0) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        return new ConfiguredFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel);
    }
}

