/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private final AndroidLogcatPreferences myPreferences;
    private static final Pattern MESSAGE_WITH_HEADER = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/([^ ]+): (.*)$");
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^\\+ (.*)$");
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);
    private int myLastHeaderLength = 0;

    public AndroidLogcatFormatter(AndroidLogcatPreferences preferences) {
        this.myPreferences = preferences;
    }

    public static String formatMessageFull(LogCatHeader header, String message) {
        return AndroidLogcatFormatter.formatMessage(FULL_FORMAT, header, message);
    }

    public static String formatContinuation(String message) {
        return String.format("+ %s", message);
    }

    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        return builder.toString();
    }

    static String formatMessage(String format, String msg) {
        if (format.isEmpty()) {
            return msg;
        }
        LogCatMessage message = AndroidLogcatFormatter.parseMessage(msg);
        return AndroidLogcatFormatter.formatMessage(format, message.getHeader(), message.getMessage());
    }

    private static String formatMessage(String format, LogCatHeader header, String message) {
        String ids = String.format(Locale.US, "%s-%s", header.getPid(), header.getTid());
        String tag = header.getTag().replace(' ', '\u00a0');
        return String.format(Locale.US, format, header.getTimestamp(), ids, header.getAppName(), Character.valueOf(header.getLogLevel().getPriorityLetter()), tag, message);
    }

    public static String formatMessage(Log.LogLevel level, String message) {
        LogCatHeader fakeHeader = new LogCatHeader(level, 0, 0, "?", "Internal", LogCatTimestamp.ZERO);
        return AndroidLogcatFormatter.formatMessageFull(fakeHeader, message);
    }

    public static LogCatMessage parseMessage(String msg) {
        LogCatMessage result = AndroidLogcatFormatter.tryParseMessage(msg);
        if (result == null) {
            throw new IllegalArgumentException("Invalid message doesn't match expected logcat pattern: " + msg);
        }
        return result;
    }

    public static LogCatMessage tryParseMessage(String msg) {
        Matcher matcher = MESSAGE_WITH_HEADER.matcher(msg);
        if (!matcher.matches()) {
            return null;
        }
        LogCatHeader header = new LogCatHeader(Log.LogLevel.getByLetter((char)matcher.group(5).charAt(0)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4), matcher.group(6), LogCatTimestamp.fromString((String)matcher.group(1)));
        String message = matcher.group(7);
        return new LogCatMessage(header, message);
    }

    public static String tryParseContinuation(String msg) {
        Matcher matcher = CONTINUATION_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public String formatPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        String[] lines = prefix.split("\n");
        StringBuilder sb = new StringBuilder(prefix.length() + (lines.length - 1) * this.myLastHeaderLength);
        for (String line : lines) {
            sb.append(this.formatMessage(line));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String formatMessage(String msg) {
        String continuation = AndroidLogcatFormatter.tryParseContinuation(msg);
        if (continuation != null) {
            return Strings.repeat((String)" ", (int)this.myLastHeaderLength) + continuation;
        }
        LogCatMessage message = AndroidLogcatFormatter.tryParseMessage(msg);
        if (message != null) {
            String formatted = AndroidLogcatFormatter.formatMessage(this.myPreferences.LOGCAT_FORMAT_STRING, msg);
            this.myLastHeaderLength = formatted.indexOf(message.getMessage());
            return formatted;
        }
        return msg;
    }
}

