/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class ToolWindowAlikePanel
extends JPanel {
    private final Header myHeader;

    public static ToolWindowAlikePanel createTreePanel(String title, JTree tree) {
        ToolWindowAlikePanel panel = new ToolWindowAlikePanel(title, ScrollPaneFactory.createScrollPane((Component)tree));
        Object root = tree.getModel().getRoot();
        if (root instanceof TreeNode && ((TreeNode)root).getChildCount() > 0) {
            DefaultTreeExpander expander = new DefaultTreeExpander(tree);
            CommonActionsManager actions = CommonActionsManager.getInstance();
            AnAction expandAllAction = actions.createExpandAllAction((TreeExpander)expander, (JComponent)tree);
            expandAllAction.getTemplatePresentation().setIcon(AllIcons.General.ExpandAll);
            AnAction collapseAllAction = actions.createCollapseAllAction((TreeExpander)expander, (JComponent)tree);
            collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
            panel.setAdditionalTitleActions(expandAllAction, collapseAllAction);
        }
        return panel;
    }

    public ToolWindowAlikePanel(String title, JComponent contents) {
        super(new BorderLayout());
        this.myHeader = new Header(title);
        this.add((Component)this.myHeader, "North");
        this.add((Component)contents, "Center");
    }

    public void setAdditionalTitleActions(AnAction ... actions) {
        this.myHeader.setAdditionalActions(actions);
    }

    private static class ActionButton
    extends Wrapper
    implements ActionListener {
        private final InplaceButton myButton;
        private final AnAction myAction;

        ActionButton(AnAction action) {
            this.myAction = action;
            Icon icon = action.getTemplatePresentation().getIcon();
            Icon hoveredIcon = action.getTemplatePresentation().getHoveredIcon();
            if (hoveredIcon == null) {
                hoveredIcon = icon;
            }
            String toolTip = KeymapUtil.createTooltipText((String)action.getTemplatePresentation().getText(), (AnAction)action);
            this.myButton = new InplaceButton(toolTip, icon, (ActionListener)this);
            this.myButton.setIcons(icon, icon, hoveredIcon);
            this.myButton.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)this.myButton);
            this.setOpaque(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            AnActionEvent event = new AnActionEvent(inputEvent, dataContext, "unknown", this.myAction.getTemplatePresentation(), ActionManager.getInstance(), 0);
            actionManager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            this.myAction.actionPerformed(event);
        }
    }

    private static class Header
    extends JPanel {
        private JPanel myButtonPanel;

        Header(String title) {
            super(new BorderLayout());
            JLabel titleLabel = new JLabel(title);
            titleLabel.setFont(BaseLabel.getLabelFont());
            titleLabel.setForeground(JBColor.foreground());
            titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add((Component)titleLabel, "Center");
            this.myButtonPanel = new JPanel();
            this.myButtonPanel.setOpaque(false);
            this.myButtonPanel.setLayout(new BoxLayout(this.myButtonPanel, 0));
            this.myButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.add((Component)this.myButtonPanel, "East");
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            BufferedImage image = Header.drawToBuffer(this.getBounds().height);
            Rectangle clipBounds = g2d.getClip().getBounds();
            for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
                UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
            }
        }

        private static BufferedImage drawToBuffer(int height) {
            int width = 150;
            BufferedImage image = UIUtil.createImage((int)width, (int)height, (int)2);
            Graphics2D g = image.createGraphics();
            UIUtil.drawHeader((Graphics)g, (int)0, (int)width, (int)height, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            g.dispose();
            return image;
        }

        @Override
        protected void paintChildren(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            UIUtil.applyRenderingHints((Graphics)graphics);
            super.paintChildren(graphics);
            graphics.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }

        void setAdditionalActions(AnAction[] actions) {
            this.myButtonPanel.removeAll();
            int actionCount = actions.length;
            for (int i = 0; i < actionCount; ++i) {
                AnAction action = actions[i];
                if (action == null) continue;
                this.myButtonPanel.add((Component)((Object)new ActionButton(action)));
                if (i >= actionCount - 1) continue;
                this.myButtonPanel.add(Box.createHorizontalStrut(9));
            }
        }
    }
}

