/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-(.*)-(.*)\\.jar");
    private static final String SOURCES_JAR_NAME_SUFFIX = "-sources.jar";
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*-([^-]+)-([^.]+).zip");

    private GradleUtil() {
    }

    public static void clearStoredGradleJvmArgs(final Project project) {
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        final String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String jvmArgs = existingJvmArgs.trim();
                    String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                    int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        try {
                            GradleProperties gradleProperties = new GradleProperties(project);
                            gradleProperties.setJvmArgs(jvmArgs);
                            gradleProperties.save();
                        }
                        catch (IOException e) {
                            String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                            LOG.info(err, (Throwable)e);
                            String cause = e.getMessage();
                            if (StringUtil.isNotEmpty((String)cause)) {
                                err = err + String.format("<br>\nCause: %1$s", cause);
                            }
                            AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                        }
                    } else {
                        String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                        AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                    }
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(FullRevision gradleVersion) {
        FullRevision supported = FullRevision.parseRevision((String)"2.2.1");
        return supported.compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    public static AndroidArtifactOutput getOutput(AndroidArtifact artifact) {
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        return output;
    }

    public static Icon getModuleIcon(Module module) {
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject != null) {
            return androidProject.isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
        }
        return Projects.requiresAndroidModel(module.getProject()) ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
    }

    public static AndroidProject getAndroidProject(Module module) {
        AndroidGradleModel gradleModel = AndroidGradleModel.get(module);
        return gradleModel != null ? gradleModel.getAndroidProject() : null;
    }

    public static String getGradlePath(Module module) {
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        return facet != null ? ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(Module module) {
        String gradlePath;
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    public static List<AndroidLibrary> getDirectLibraryDependencies(Variant variant, AndroidGradleModel androidModel) {
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(variant.getMainArtifact().getDependencies().getLibraries());
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifact(variant);
        if (testArtifact != null) {
            libraries.addAll(testArtifact.getDependencies().getLibraries());
        }
        return libraries;
    }

    public static Module findModuleByGradlePath(Project project, String gradlePath) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    public static List<String> getPathSegments(String gradlePath) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
    }

    public static VirtualFile getGradleBuildFile(Module module) {
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModel() != null) {
            return gradleFacet.getGradleModel().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    public static VirtualFile getGradleBuildFile(File dirPath) {
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    public static File getGradleBuildFilePath(File dirPath) {
        return new File(dirPath, "build.gradle");
    }

    public static VirtualFile getGradleSettingsFile(File dirPath) {
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    public static File getGradleSettingsFilePath(File dirPath) {
        return new File(dirPath, "settings.gradle");
    }

    public static File getGradleWrapperPropertiesFilePath(File projectRootDir) {
        return new File(projectRootDir, GRADLEW_PROPERTIES_PATH);
    }

    public static boolean updateGradleDistributionUrl(String gradleVersion, File propertiesFile) throws IOException {
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String gradleDistributionUrl = GradleUtil.getGradleDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(gradleDistributionUrl) || property.equals(GradleUtil.getGradleDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", gradleDistributionUrl);
        PropertiesUtil.savePropertiesToFile(properties, propertiesFile, null);
        return true;
    }

    public static String getGradleWrapperVersion(File propertiesFile) throws IOException {
        Matcher m;
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String url = properties.getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    private static String getGradleDistributionUrl(String gradleVersion, boolean binOnly) {
        String suffix = binOnly ? "bin" : "all";
        return String.format("https://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
    }

    public static GradleExecutionSettings getGradleExecutionSettings(Project project) {
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        Sdk jdk = IdeSdks.getJdk();
        if (jdk != null) {
            projectSettings.setGradleJvm(jdk.getName());
        }
        try {
            GradleExecutionSettings settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
            if (settings != null) {
                settings.setRemoteProcessIdleTtlInMs(-1L);
            }
            return settings;
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    public static File findWrapperPropertiesFile(Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(baseDir);
        return wrapperPropertiesFile.isFile() ? wrapperPropertiesFile : null;
    }

    public static GradleProjectSettings getGradleProjectSettings(Project project) {
        GradleSettings settings = (GradleSettings)ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GRADLE_SYSTEM_ID);
        GradleSettings.MyState state = settings.getState();
        assert (state != null);
        Set allProjectsSettings = state.getLinkedExternalProjectsSettings();
        return GradleUtil.getFirstNotNull(allProjectsSettings);
    }

    private static GradleProjectSettings getFirstNotNull(Set<GradleProjectSettings> allProjectSettings) {
        if (allProjectSettings != null) {
            for (GradleProjectSettings settings : allProjectSettings) {
                if (settings == null) continue;
                return settings;
            }
        }
        return null;
    }

    @VisibleForTesting
    static String getGradleInvocationJvmArg(BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    public static String getDefaultPhysicalPathFromGradlePath(String gradlePath) {
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        return FileUtil.join((String[])ArrayUtil.toStringArray(segments));
    }

    public static File getModuleDefaultPath(VirtualFile parentDir, String gradlePath) {
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
    }

    public static int isValidGradlePath(String gradlePath) {
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(Project project, String gradlePath, boolean checkProjectFolder) {
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    public static void cleanUpPreferences(ExtensionPoint<ConfigurableEP<Configurable>> preferences, List<String> bundlesToRemove) {
        ConfigurableEP[] extensions;
        ArrayList nonStudioExtensions = Lists.newArrayList();
        for (ConfigurableEP extension : extensions = (ConfigurableEP[])preferences.getExtensions()) {
            if (!bundlesToRemove.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        for (ConfigurableEP toRemove : nonStudioExtensions) {
            preferences.unregisterExtension((Object)toRemove);
        }
    }

    public static FullRevision getGradleVersion(Project project) {
        FullRevision revision;
        String gradleVersion = Projects.getGradleVersionUsed(project);
        if (StringUtil.isNotEmpty((String)gradleVersion) && (revision = GradleUtil.parseRevision(GradleUtil.removeTimestampFromGradleVersion(gradleVersion))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
                if (wrapperPropertiesFile != null) {
                    try {
                        String wrapperVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
                        if (wrapperVersion != null) {
                            return GradleUtil.parseRevision(GradleUtil.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        LOG.info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return GradleUtil.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    public static FullRevision getGradleVersion(File gradleHomePath) {
        File libDirPath = new File(gradleHomePath, "lib");
        for (File child : FileUtil.notNullize((File[])libDirPath.listFiles())) {
            FullRevision version = GradleUtil.getGradleVersionFromJar(child);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @VisibleForTesting
    static FullRevision getGradleVersionFromJar(File libraryJarFile) {
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version = matcher.group(2);
            try {
                return PreciseRevision.parseRevision((String)GradleUtil.removeTimestampFromGradleVersion(version));
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("Unable to parse version '%1$s' (obtained from file '%2$s')", version, fileName));
            }
        }
        return null;
    }

    private static String removeTimestampFromGradleVersion(String gradleVersion) {
        int dashIndex = gradleVersion.indexOf(45);
        if (dashIndex != -1) {
            return gradleVersion.substring(0, dashIndex);
        }
        return gradleVersion;
    }

    public static boolean createGradleWrapper(File projectDirPath) throws IOException {
        return GradleUtil.createGradleWrapper(projectDirPath, "2.8");
    }

    @VisibleForTesting
    public static boolean createGradleWrapper(File projectDirPath, String gradleVersion) throws IOException {
        File projectWrapperDirPath = new File(projectDirPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!projectWrapperDirPath.isDirectory()) {
            File wrapperSrcDirPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!wrapperSrcDirPath.exists()) {
                File root;
                Iterator<File> i$ = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (i$.hasNext() && !(wrapperSrcDirPath = new File(root = i$.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    wrapperSrcDirPath = null;
                }
            }
            if (wrapperSrcDirPath == null) {
                return false;
            }
            FileUtil.copyDirContent((File)wrapperSrcDirPath, (File)projectDirPath);
        }
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(projectDirPath);
        GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
        return true;
    }

    public static FullRevision getAndroidGradleModelVersionInUse(Project project) {
        SmartHashSet pluginVersionsUsedInProject = new SmartHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidProject androidProject = GradleUtil.getAndroidProject(module);
            if (androidProject == null) continue;
            pluginVersionsUsedInProject.add(androidProject.getModelVersion());
        }
        if (pluginVersionsUsedInProject.size() == 1) {
            return GradleUtil.parseRevision((String)Iterables.getOnlyElement((Iterable)pluginVersionsUsedInProject));
        }
        return null;
    }

    public static FullRevision getAndroidGradleModelVersionFromBuildFile(final Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        final Ref modelVersionRef = new Ref();
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if ("build.gradle".equals(virtualFile.getName())) {
                    File fileToCheck = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    try {
                        String contents = FileUtil.loadFile((File)fileToCheck);
                        FullRevision version = GradleUtil.getAndroidGradleModelVersionFromBuildFile(contents, project);
                        if (version != null) {
                            modelVersionRef.set((Object)version);
                            return false;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to read contents of " + fileToCheck.getPath());
                    }
                }
                return true;
            }
        });
        return (FullRevision)modelVersionRef.get();
    }

    @VisibleForTesting
    static FullRevision getAndroidGradleModelVersionFromBuildFile(String fileContents, Project project) {
        String revision;
        GradleCoordinate found = GradleUtil.getPluginDefinition(fileContents, "com.android.tools.build:gradle:");
        if (found != null && StringUtil.isNotEmpty((String)(revision = GradleUtil.getAndroidGradleModelVersion(found, project)))) {
            return GradleUtil.parseRevision(revision);
        }
        return null;
    }

    private static FullRevision parseRevision(String revision) {
        try {
            return PreciseRevision.parseRevision((String)revision);
        }
        catch (NumberFormatException e) {
            LOG.info("Failed to parse revision '" + revision + "'", (Throwable)e);
            return null;
        }
    }

    public static GradleCoordinate getPluginDefinition(String fileContents, String pluginName) {
        String definition = GradleUtil.findStringLiteral(pluginName, fileContents, new Function<Pair<String, GroovyLexer>, String>(){

            public String fun(Pair<String, GroovyLexer> pair) {
                return (String)pair.getFirst();
            }
        });
        return StringUtil.isNotEmpty((String)definition) ? GradleCoordinate.parseCoordinateString((String)definition) : null;
    }

    public static boolean updateGradleDependencyVersion(Project project, final Document buildFileDocument, final String dependencyName, final Computable<String> versionTask) {
        String contents = buildFileDocument.getText();
        final TextRange range = GradleUtil.findStringLiteral(dependencyName, contents, new Function<Pair<String, GroovyLexer>, TextRange>(){

            public TextRange fun(Pair<String, GroovyLexer> pair) {
                GroovyLexer lexer = (GroovyLexer)pair.getSecond();
                return TextRange.create((int)(lexer.getTokenStart() + 1 + dependencyName.length()), (int)(lexer.getTokenEnd() - 1));
            }
        });
        if (range != null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    buildFileDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)versionTask.compute());
                }
            });
            return true;
        }
        return false;
    }

    public static TextRange findDependency(String dependency, String contents) {
        return GradleUtil.findStringLiteral(dependency, contents, new Function<Pair<String, GroovyLexer>, TextRange>(){

            public TextRange fun(Pair<String, GroovyLexer> pair) {
                GroovyLexer lexer = (GroovyLexer)pair.getSecond();
                return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
            }
        });
    }

    private static <T> T findStringLiteral(String textToSearchPrefix, String fileContents, Function<Pair<String, GroovyLexer>, T> consumer) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(textToSearchPrefix)) {
                return (T)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    public static String getPluginDefinitionString(String fileContents, String pluginName) {
        return GradleUtil.forPluginDefinition(fileContents, pluginName, new Function<Pair<String, GroovyLexer>, String>(){

            public String fun(Pair<String, GroovyLexer> pair) {
                return (String)pair.getFirst();
            }
        });
    }

    public static <T> T forPluginDefinition(String fileContents, String pluginName, Function<Pair<String, GroovyLexer>, T> consumer) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(pluginName)) {
                return (T)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    private static String getAndroidGradleModelVersion(GradleCoordinate coordinate, Project project) {
        GradleCoordinate latest;
        String revision = coordinate.getFullRevision();
        if (StringUtil.isNotEmpty((String)revision)) {
            if (!coordinate.acceptsGreaterRevisions()) {
                return revision;
            }
            int major = coordinate.getMajorVersion();
            int minor = coordinate.getMinorVersion();
            if (coordinate.getMicroVersion() == -1 && major >= 0 && minor > 0) {
                return major + "." + minor + "." + 0;
            }
        }
        return (latest = GradleUtil.findLatestVersionInGradleCache(coordinate, null, project)) != null ? latest.getFullRevision() : null;
    }

    public static GradleCoordinate findLatestVersionInGradleCache(GradleCoordinate original, String filter, Project project) {
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            GradleCoordinate version = GradleUtil.findLatestVersionInGradleCache(gradleServicePath, original, filter);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    private static GradleCoordinate findLatestVersionInGradleCache(File gradleServicePath, GradleCoordinate original, String filter) {
        File gradleCache = new File(gradleServicePath, "caches");
        if (gradleCache.exists()) {
            ArrayList coordinates = Lists.newArrayList();
            String groupId = original.getGroupId();
            String artifactId = original.getArtifactId();
            for (File moduleDir : FileUtil.notNullize((File[])gradleCache.listFiles())) {
                if (!moduleDir.getName().startsWith("modules-") || !moduleDir.isDirectory()) continue;
                for (File metadataDir : FileUtil.notNullize((File[])moduleDir.listFiles())) {
                    File versionDir;
                    if (!metadataDir.getName().startsWith("metadata-") || !metadataDir.isDirectory() || !(versionDir = new File(metadataDir, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                    for (File version : FileUtil.notNullize((File[])versionDir.listFiles())) {
                        GradleCoordinate found;
                        String name = version.getName();
                        if (filter != null && !name.startsWith(filter) || name.isEmpty() || !Character.isDigit(name.charAt(0)) || (found = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + name))) == null) continue;
                        coordinates.add(found);
                    }
                }
            }
            if (!coordinates.isEmpty()) {
                Collections.sort(coordinates, GradleCoordinate.COMPARE_PLUS_LOWER);
                return (GradleCoordinate)coordinates.get(coordinates.size() - 1);
            }
        }
        return null;
    }

    public static void addLocalMavenRepoInitScriptCommandLineOption(List<String> args) {
        File repoPath;
        if ((AndroidStudioInitializer.isAndroidStudio() || ApplicationManager.getApplication().isUnitTestMode()) && (repoPath = EmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPath()) != null && repoPath.isDirectory()) {
            GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args, repoPath);
        }
    }

    @VisibleForTesting
    static File addLocalMavenRepoInitScriptCommandLineOption(List<String> args, File repoPath) {
        try {
            File file = FileUtil.createTempFile((String)"asLocalRepo", (String)".gradle");
            file.deleteOnExit();
            String contents = "allprojects {\n  buildscript {\n    repositories {\n      maven { url '" + GradleImport.escapeGroovyStringLiteral(repoPath.getPath()) + "'}\n" + "    }\n" + "  }\n" + "}\n";
            FileUtil.writeToFile((File)file, (String)contents);
            ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", file.getAbsolutePath()});
            return file;
        }
        catch (IOException e) {
            LOG.warn("Failed to set up 'local repo' Gradle init script", (Throwable)e);
            return null;
        }
    }

    public static void attemptToUseEmbeddedGradle(Project project) {
        File wrapperPropertiesFile;
        if (AndroidStudioInitializer.isAndroidStudio() && (wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = PropertiesUtil.getProperties(wrapperPropertiesFile);
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + wrapperPropertiesFile.getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleUtil.isWrapperInGradleCache(project, gradleVersion) && (embeddedGradlePath = EmbeddedDistributionPaths.findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(String gradleVersion) {
        return gradleVersion.equals("2.2.1") || gradleVersion.equals("2.8");
    }

    private static boolean isWrapperInGradleCache(Project project, String gradleVersion) {
        String distFolderDirName = "gradle-" + gradleVersion;
        String wrapperDirNamePrefix = distFolderDirName + "-";
        String[] wrapperDirNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            for (String wrapperDirName : wrapperDirNames) {
                File wrapperDirPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperDirName}));
                if (!wrapperDirPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperDirPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderDirName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static Collection<File> getGradleServicePaths(Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet paths = Sets.newLinkedHashSet();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths.add(file);
        }
        if ((path = new File(SystemProperties.getUserHome(), ".gradle")).isDirectory()) {
            paths.add(path);
        }
        return paths;
    }

    public static boolean dependsOn(AndroidGradleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getMainArtifact().getDependencies();
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    private static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        String s;
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.equals(s = resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return true;
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                if (!GradleUtil.dependsOn(dependency, artifact, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCause(Throwable e, Class<?> causeClass) {
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    public static DataNode<ProjectData> getCachedProjectData(Project project) {
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(project, GRADLE_SYSTEM_ID, Projects.getBaseDirPath(project).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public static boolean hasLayoutRenderingIssue(AndroidProject model) {
        String modelVersion = model.getModelVersion();
        return modelVersion.startsWith("1.2.0") || modelVersion.equals("1.2.1") || modelVersion.equals("1.2.2");
    }

    public static VirtualFile findSourceJarForLibrary(File libraryFilePath) {
        VirtualFile realJarFile = VfsUtil.findFileByIoFile((File)libraryFilePath, (boolean)true);
        if (realJarFile == null) {
            return null;
        }
        VirtualFile parent = realJarFile.getParent();
        String name = FileUtil.getNameWithoutExtension((File)libraryFilePath);
        String sourceFileName = name + SOURCES_JAR_NAME_SUFFIX;
        if (parent != null) {
            VirtualFile sourceJar = parent.findChild(sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parent = parent.getParent()) != null) {
                for (VirtualFile child : parent.getChildren()) {
                    if (!child.isDirectory() || (sourceJar = child.findChild(sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        File librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir();
        File sourceJar = new File(librarySourceDirPath, sourceFileName);
        return VfsUtil.findFileByIoFile((File)sourceJar, (boolean)true);
    }
}

