/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class GradleProperties {
    private static final String JVM_ARGS_PROPERTY_NAME = "org.gradle.jvmargs";
    private final File myPath;
    private final Properties myProperties;

    public GradleProperties(Project project) throws IOException {
        this(new File(Projects.getBaseDirPath(project), "gradle.properties"));
    }

    @VisibleForTesting
    GradleProperties(File path) throws IOException {
        this.myPath = path;
        this.myProperties = PropertiesUtil.getProperties(this.myPath);
    }

    @VisibleForTesting
    String getProperty(String name) {
        return this.myProperties.getProperty(name);
    }

    public ProxySettings getHttpProxySettings() {
        return new ProxySettings(this.myProperties, "http");
    }

    public ProxySettings getHttpsProxySettings() {
        return new ProxySettings(this.myProperties, "https");
    }

    public void save() throws IOException {
        PropertiesUtil.savePropertiesToFile(this.myProperties, this.myPath, GradleProperties.getHeaderComment());
    }

    private static String getHeaderComment() {
        Object[] lines = new String[]{"# Project-wide Gradle settings.", "", "# For more details on how to configure your build environment visit", "# http://www.gradle.org/docs/current/userguide/build_environment.html", "", "# Specifies the JVM arguments used for the daemon process.", "# The setting is particularly useful for tweaking memory settings.", "# Default value: -Xmx10248m -XX:MaxPermSize=256m", "# org.gradle.jvmargs=-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8", "", "# When configured, Gradle will run in incubating parallel mode.", "# This option should only be used with decoupled projects. More details, visit", "# http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects", "# org.gradle.parallel=true"};
        return Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
    }

    public void setJvmArgs(String jvmArgs) {
        this.myProperties.setProperty(JVM_ARGS_PROPERTY_NAME, jvmArgs);
    }

    public void clear() {
        this.myProperties.clear();
    }

    public String getJvmArgs() {
        return this.myProperties.getProperty(JVM_ARGS_PROPERTY_NAME);
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public File getPath() {
        return this.myPath;
    }
}

