/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Function;
import com.intellij.util.Processor;

public class SearchInBuildFilesHyperlink
extends NotificationHyperlink {
    private final String myTextToFind;

    public SearchInBuildFilesHyperlink(String textToFind) {
        this("searchInBuildFiles", "Search in build.gradle files", textToFind);
    }

    public SearchInBuildFilesHyperlink(String url, String text, String textToFind) {
        super(url, text);
        this.myTextToFind = textToFind;
    }

    @Override
    protected void execute(final Project project) {
        FindManager findManager = FindManager.getInstance((Project)project);
        UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
        FindModel findModel = findManager.getFindInProjectModel().clone();
        findModel.setStringToFind(this.myTextToFind);
        findModel.setReplaceState(false);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(true);
        findModel.setOpenInNewTab(true);
        findModel.setFileFilter("build.gradle");
        findManager.getFindInProjectModel().copyFrom(findModel);
        final FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation((boolean)findModel.isOpenInNewTabEnabled(), (FindModel)findModelCopy);
        boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
        final FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation((Project)project, (boolean)showPanelIfOnlyOneUsage, (UsageViewPresentation)presentation);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(project, findModel);
        usageViewManager.searchAndShowUsages(new UsageTarget[]{usageTarget}, (Factory)new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageSearcher(){

                    public void generate(Processor<Usage> processor) {
                        AdapterProcessor consumer = new AdapterProcessor(processor, (Function)UsageInfo2UsageAdapter.CONVERTER);
                        FindInProjectUtil.findUsages((FindModel)findModelCopy, null, (Project)project, (Processor)consumer, (FindUsagesProcessPresentation)processPresentation);
                    }
                };
            }
        }, processPresentation, presentation, null);
    }
}

