/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    private final String myVersion;
    private final VirtualFile myBuildFile;

    public InstallBuildToolsHyperlink(String version, VirtualFile buildFile) {
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version, buildFile));
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    private static String getText(String version, VirtualFile buildFile) {
        String msg = String.format("Install Build Tools %1$s", version);
        msg = buildFile != null ? msg + ", update version in build file and sync project" : msg + " and sync project";
        return msg;
    }

    @Override
    protected void execute(Project project) {
        ArrayList requested = Lists.newArrayList();
        FullRevision minBuildToolsRev = FullRevision.parseRevision((String)this.myVersion);
        requested.add(PkgDesc.Builder.newBuildTool((FullRevision)minBuildToolsRev).create());
        SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
        wizard.init();
        if (wizard.showAndGet()) {
            if (this.myBuildFile != null) {
                FixBuildToolsVersionHyperlink.fixBuildToolsVersionAndSync(project, this.myBuildFile, this.myVersion);
            } else {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }
}

